/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jms;

import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.jms.DualSessionWrapper;
import bitronix.tm.resource.jms.PoolingConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public class MessageProducerWrapper
implements MessageProducer {
    private MessageProducer messageProducer;
    protected DualSessionWrapper session;
    private PoolingConnectionFactory poolingConnectionFactory;

    public MessageProducerWrapper(MessageProducer messageProducer, DualSessionWrapper session, PoolingConnectionFactory poolingConnectionFactory) {
        this.messageProducer = messageProducer;
        this.session = session;
        this.poolingConnectionFactory = poolingConnectionFactory;
    }

    public MessageProducer getMessageProducer() {
        return this.messageProducer;
    }

    protected void enlistResource() throws JMSException {
        if (this.poolingConnectionFactory.getAutomaticEnlistingEnabled()) {
            this.session.getSession();
            try {
                TransactionContextHelper.enlistInCurrentTransaction(this.session);
            }
            catch (SystemException ex) {
                throw (JMSException)new JMSException("error enlisting " + this).initCause((Throwable)ex);
            }
            catch (RollbackException ex) {
                throw (JMSException)new JMSException("error enlisting " + this).initCause((Throwable)ex);
            }
        }
    }

    public String toString() {
        return "a MessageProducerWrapper of " + this.session;
    }

    public void send(Message message) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.enlistResource();
        this.getMessageProducer().send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void close() throws JMSException {
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.getMessageProducer().setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.getMessageProducer().getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.getMessageProducer().setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.getMessageProducer().getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.getMessageProducer().setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.getMessageProducer().getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.getMessageProducer().setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.getMessageProducer().getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.getMessageProducer().setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.getMessageProducer().getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.getMessageProducer().getDestination();
    }
}

