/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.twopc.executor;

import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.twopc.executor.Executor;
import bitronix.tm.twopc.executor.Job;
import bitronix.tm.utils.ClassLoaderUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentExecutor.class);
    private static final String[] implementations = new String[]{"java.util.concurrent.Executors", "java.util.concurrent.ExecutorService", "java.util.concurrent.Future", "java.util.concurrent.TimeUnit"};
    private Object executorService;
    private Method executorServiceSubmitMethod;
    private Method executorServiceShutdownMethod;
    private Method futureGetMethod;
    private Method futureIsDoneMethod;
    private Object timeUnitMilliseconds;
    private boolean usable = false;

    public ConcurrentExecutor() {
        this(implementations);
    }

    protected ConcurrentExecutor(String[] implementations) {
        this.init(implementations);
    }

    private void init(String[] implementations) {
        String executorsImpl;
        block5: {
            executorsImpl = implementations[0];
            String executorServiceImpl = implementations[1];
            String futureImpl = implementations[2];
            String timeUnitImpl = implementations[3];
            if (log.isDebugEnabled()) {
                log.debug("initializing concurrent executor implementation <" + executorsImpl + ">");
            }
            try {
                Class executorsClass = ClassLoaderUtils.loadClass(executorsImpl);
                Class executorServiceClass = ClassLoaderUtils.loadClass(executorServiceImpl);
                Class timeUnitClass = ClassLoaderUtils.loadClass(timeUnitImpl);
                this.executorService = executorsClass.getMethod("newCachedThreadPool", null).invoke((Object)executorsClass, (Object[])null);
                this.executorServiceSubmitMethod = executorServiceClass.getMethod("submit", Runnable.class);
                this.executorServiceShutdownMethod = executorServiceClass.getMethod("shutdownNow", null);
                this.timeUnitMilliseconds = timeUnitClass.getField("MILLISECONDS").get(timeUnitClass);
                this.futureGetMethod = ClassLoaderUtils.loadClass(futureImpl).getMethod("get", Long.TYPE, timeUnitClass);
                this.futureIsDoneMethod = ClassLoaderUtils.loadClass(futureImpl).getMethod("isDone", null);
                if (log.isDebugEnabled()) {
                    log.debug("found a valid implementation for this executor <" + executorsImpl + ">");
                }
                this.usable = true;
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block5;
                log.debug("error accessing executor implementation <" + executorsImpl + ">", (Throwable)ex);
            }
        }
        if (!this.usable && log.isDebugEnabled()) {
            log.debug("cannot find a valid implementation for executor <" + executorsImpl + ">, disabling it");
        }
    }

    public Object submit(Job job) {
        if (!this.isUsable()) {
            throw new BitronixRuntimeException("concurrent executor is disabled because there is no valid executor implementation");
        }
        try {
            return this.executorServiceSubmitMethod.invoke(this.executorService, job);
        }
        catch (IllegalAccessException ex) {
            throw new BitronixRuntimeException("error calling ExecutorService.submit(Runnable task)", ex);
        }
        catch (InvocationTargetException ex) {
            throw new BitronixRuntimeException("error calling ExecutorService.submit(Runnable task)", ex);
        }
    }

    public void waitFor(Object future, long timeout) {
        if (!this.isUsable()) {
            throw new BitronixRuntimeException("concurrent executor is disabled because there is no valid executor implementation");
        }
        try {
            this.futureGetMethod.invoke(future, new Long(timeout), this.timeUnitMilliseconds);
        }
        catch (IllegalAccessException ex) {
            throw new BitronixRuntimeException("error calling Future.get()", ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause().getClass().getName().endsWith("TimeoutException")) {
                return;
            }
            throw new BitronixRuntimeException("error calling Future.get()", ex);
        }
    }

    public boolean isDone(Object future) {
        if (!this.isUsable()) {
            throw new BitronixRuntimeException("concurrent executor is disabled because there is no valid executor implementation");
        }
        try {
            Boolean b = (Boolean)this.futureIsDoneMethod.invoke(future, (Object[])null);
            return b;
        }
        catch (IllegalAccessException ex) {
            throw new BitronixRuntimeException("error calling Future.isDone()", ex);
        }
        catch (InvocationTargetException ex) {
            throw new BitronixRuntimeException("error calling Future.isDone()", ex);
        }
    }

    public boolean isUsable() {
        return this.usable;
    }

    public synchronized void shutdown() {
        if (!this.isUsable()) {
            throw new BitronixRuntimeException("concurrent executor is disabled because there is no valid executor implementation");
        }
        try {
            this.executorServiceShutdownMethod.invoke(this.executorService, (Object[])null);
        }
        catch (IllegalAccessException ex) {
            throw new BitronixRuntimeException("error calling ExecutorService.shutdown()", ex);
        }
        catch (InvocationTargetException ex) {
            throw new BitronixRuntimeException("error calling ExecutorService.shutdown()", ex);
        }
    }
}

