/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.internal.XAResourceHolderState;
import java.util.Collection;
import java.util.Iterator;
import javax.transaction.xa.XAException;

public class Decoder {
    public static String decodeXAExceptionErrorCode(XAException ex) {
        switch (ex.errorCode) {
            case 100: {
                return "XA_RBROLLBACK";
            }
            case 101: {
                return "XA_RBCOMMFAIL";
            }
            case 102: {
                return "XA_RBDEADLOCK";
            }
            case 107: {
                return "XA_RBTRANSIENT";
            }
            case 103: {
                return "XA_RBINTEGRITY";
            }
            case 104: {
                return "XA_RBOTHER";
            }
            case 105: {
                return "XA_RBPROTO";
            }
            case 106: {
                return "XA_RBTIMEOUT";
            }
            case 7: {
                return "XA_HEURCOM";
            }
            case 8: {
                return "XA_HEURHAZ";
            }
            case 5: {
                return "XA_HEURMIX";
            }
            case 6: {
                return "XA_HEURRB";
            }
            case -3: {
                return "XAER_RMERR";
            }
            case -7: {
                return "XAER_RMFAIL";
            }
            case -4: {
                return "XAER_NOTA";
            }
            case -5: {
                return "XAER_INVAL";
            }
            case -6: {
                return "XAER_PROTO";
            }
            case -2: {
                return "XAER_ASYNC";
            }
            case -8: {
                return "XAER_DUPID";
            }
            case -9: {
                return "XAER_OUTSIDE";
            }
        }
        return "!invalid error code (" + ex.errorCode + ")!";
    }

    public static String decodeStatus(int status) {
        switch (status) {
            case 0: {
                return "ACTIVE";
            }
            case 3: {
                return "COMMITTED";
            }
            case 8: {
                return "COMMITTING";
            }
            case 1: {
                return "MARKED_ROLLBACK";
            }
            case 6: {
                return "NO_TRANSACTION";
            }
            case 2: {
                return "PREPARED";
            }
            case 7: {
                return "PREPARING";
            }
            case 4: {
                return "ROLLEDBACK";
            }
            case 9: {
                return "ROLLING_BACK";
            }
            case 5: {
                return "UNKNOWN";
            }
        }
        return "!incorrect status (" + status + ")!";
    }

    public static String decodeXAResourceFlag(int flag) {
        switch (flag) {
            case 0x800000: {
                return "ENDRSCAN";
            }
            case 0x20000000: {
                return "FAIL";
            }
            case 0x200000: {
                return "JOIN";
            }
            case 0: {
                return "NOFLAGS";
            }
            case 0x40000000: {
                return "ONEPHASE";
            }
            case 0x8000000: {
                return "RESUME";
            }
            case 0x1000000: {
                return "STARTRSCAN";
            }
            case 0x4000000: {
                return "SUCCESS";
            }
            case 0x2000000: {
                return "SUSPEND";
            }
        }
        return "!invalid flag (" + flag + ")!";
    }

    public static String decodePrepareVote(int vote) {
        switch (vote) {
            case 0: {
                return "XA_OK";
            }
            case 3: {
                return "XA_RDONLY";
            }
        }
        return "!invalid return code (" + vote + ")!";
    }

    public static String decodeHeaderState(byte state) {
        switch (state) {
            case 0: {
                return "CLEAN_LOG_STATE";
            }
            case -1: {
                return "UNCLEAN_LOG_STATE";
            }
        }
        return "!invalid state (" + state + ")!";
    }

    public static String decodeXAStatefulHolderState(int state) {
        switch (state) {
            case 0: {
                return "CLOSED";
            }
            case 1: {
                return "IN_POOL";
            }
            case 2: {
                return "ACCESSIBLE";
            }
            case 3: {
                return "NOT_ACCESSIBLE";
            }
        }
        return "!invalid state (" + state + ")!";
    }

    public static String collectResourcesNames(Collection resources) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            XAResourceHolderState resourceHolderState = (XAResourceHolderState)it.next();
            sb.append(resourceHolderState.getUniqueName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

