/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.resteasy.client.core.ClientMarshallerFactory;
import org.jboss.resteasy.client.core.Marshaller;
import org.jboss.resteasy.client.core.WebRequestIntializer;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.IsHttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriFor {
    public static String resolve(Class<? extends Object> clazz, String methodName, Object ... args) {
        if (methodName == null) {
            throw new RuntimeException("A URL cannot be created for a null method.");
        }
        try {
            return UriFor.resolve(new URI("/"), clazz, methodName, true, args);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static String resolve(URI baseUri, Class<? extends Object> clazz, String methodName, Object ... args) {
        return UriFor.resolve(baseUri, clazz, methodName, false, args);
    }

    public static String resolve(URI baseUri, Class<? extends Object> clazz, String methodName, boolean allowRelative, Object ... args) {
        Method m = UriFor.getMethod(clazz, methodName, args);
        return m == null ? null : UriFor.resolve(baseUri, allowRelative, m, args);
    }

    public static String resolve(URI baseUri, boolean allowRelative, Method method, Object ... args) {
        return UriFor.resolve(baseUri, allowRelative, method, ResteasyProviderFactory.getInstance(), args);
    }

    public static String resolve(URI baseUri, boolean allowRelative, Method method, ResteasyProviderFactory providerFactory, Object ... args) {
        Marshaller[] marshallers = ClientMarshallerFactory.createMarshallers(method, providerFactory);
        WebRequestIntializer urlRetriever = new WebRequestIntializer(marshallers);
        return urlRetriever.buildUrl(baseUri, allowRelative, method, args);
    }

    public static Method getMethod(Class<? extends Object> clazz, String methodName, Object ... args) {
        if (methodName == null) {
            return null;
        }
        Method m = null;
        for (Method method : clazz.getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!method.getName().equals(methodName) || args.length != parameterTypes.length || IsHttpMethod.getHttpMethods(method) == null || !UriFor.isMatch(parameterTypes, args)) continue;
            return method;
        }
        return m;
    }

    private static boolean isMatch(Class<?>[] parameterTypes, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Class<?> type = parameterTypes[i];
            if (!(args[i] == null ? type.isPrimitive() : !type.isInstance(args[0]))) continue;
            return false;
        }
        return true;
    }
}

