/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class FileProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final String PREFIX = "pfx";
    private static final String SUFFIX = "sfx";
    private String _downloadDirectory = null;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class == type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        File downloadedFile = null;
        if (this._downloadDirectory != null) {
            try {
                downloadedFile = File.createTempFile(PREFIX, SUFFIX, new File(this._downloadDirectory));
            }
            catch (IOException ex) {
                System.err.println("Could not bind to specified download directory " + this._downloadDirectory + " so will use temp dir.");
            }
        }
        if (downloadedFile == null) {
            downloadedFile = File.createTempFile(PREFIX, SUFFIX);
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(downloadedFile));
        try {
            ProviderHelper.writeTo(entityStream, output);
        }
        finally {
            ((OutputStream)output).close();
        }
        return downloadedFile;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class.isAssignableFrom(type);
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (o instanceof File) {
            return ((File)o).length();
        }
        System.err.println("FileProvider.getSize - something went wrong, as parameter is not a File!");
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        if (o instanceof File) {
            File uploadFile = (File)o;
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(uploadFile));
            try {
                ProviderHelper.writeTo(inputStream, entityStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        } else {
            System.err.println("FileProvider.writeTo - parameter is not a File!");
        }
    }
}

