/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import java.util.Iterator;
import org.eclipse.birt.chart.computation.Object3D;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.I3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class Polygon3DRenderEvent
extends PolygonRenderEvent
implements I3DRenderEvent {
    private static final long serialVersionUID = -6572679563207168795L;
    private boolean bDoubleSided = false;
    private double dBrightness = 1.0;
    private boolean bBehind = false;
    private Object3D object3D;
    private Fill runtimeBackground;

    public Polygon3DRenderEvent(Object oSource) {
        super(oSource);
    }

    public boolean isDoubleSided() {
        return this.bDoubleSided;
    }

    public void setDoubleSided(boolean value) {
        this.bDoubleSided = value;
    }

    public boolean isBehind() {
        return this.bBehind;
    }

    public void setBehind(boolean value) {
        this.bBehind = value;
    }

    public void setBackground(Fill ifBackground) {
        super.setBackground(ifBackground);
        this.runtimeBackground = ifBackground;
    }

    public Fill getBackground() {
        return this.runtimeBackground;
    }

    public double getBrightness() {
        return this.dBrightness;
    }

    protected void applyBrightness(ColorDefinition cdf, double brightness) {
        cdf.set((int)((double)cdf.getRed() * this.dBrightness), (int)((double)cdf.getGreen() * this.dBrightness), (int)((double)cdf.getBlue() * this.dBrightness), cdf.getTransparency());
    }

    protected void applyBrightnessToFill(Fill fill, double brightness) {
        if (fill instanceof ColorDefinition) {
            ColorDefinition cdf = (ColorDefinition)fill;
            this.applyBrightness(cdf, this.dBrightness);
        } else if (fill instanceof Gradient) {
            Gradient gradient = (Gradient)fill;
            this.applyBrightness(gradient.getStartColor(), this.dBrightness);
            this.applyBrightness(gradient.getEndColor(), this.dBrightness);
        } else if (fill instanceof MultipleFill) {
            Iterator iter = ((MultipleFill)fill).getFills().iterator();
            while (iter.hasNext()) {
                this.applyBrightnessToFill((Fill)iter.next(), brightness);
            }
        }
    }

    public void setBrightness(double value) {
        this.dBrightness = value;
        if (this._ifBackground != null) {
            Fill fill = (Fill)EcoreUtil.copy((EObject)this._ifBackground);
            this.applyBrightnessToFill(fill, this.dBrightness);
            this.runtimeBackground = fill;
        }
    }

    public final void setPoints3D(Location3D[] loa) throws ChartException {
        this.setPoints3D(loa, false);
    }

    public final void setPoints3D(Location3D[] loa, boolean inverted) throws ChartException {
        if (loa.length < 3) {
            throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.3D.points.length.less.than.3", Messages.getResourceBundle());
        }
        this.object3D = new Object3D(loa, inverted);
    }

    public Location3D[] getPoints3D() {
        return this.object3D.getLocation3D();
    }

    public void prepare2D(double xOffset, double yOffset) {
        Location[] points = this.object3D.getPoints2D(xOffset, yOffset);
        this.setPoints(points);
    }

    public PrimitiveRenderEvent copy() {
        Polygon3DRenderEvent pre = new Polygon3DRenderEvent(this.source);
        if (this.object3D != null) {
            pre.object3D = new Object3D(this.object3D);
        }
        if (this._lia != null) {
            pre.setOutline(LineAttributesImpl.copyInstance(this._lia));
        }
        if (this._ifBackground != null) {
            pre.setBackground(FillUtil.copyOf(this._ifBackground));
        }
        pre.bDoubleSided = this.bDoubleSided;
        pre.dBrightness = this.dBrightness;
        pre.bBehind = this.bBehind;
        return pre;
    }

    public void reset() {
        if (this.object3D != null) {
            this.object3D.reset();
        }
        this.bDoubleSided = false;
        this.dBrightness = 1.0;
        this.bBehind = false;
        this.runtimeBackground = null;
        super.reset();
    }

    public Object3D getObject3D() {
        return this.object3D;
    }
}

