/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ByteBuffer;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUResourceBundleReader;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceBundleIterator;
import com.ibm.icu.util.UResourceTypeMismatchException;
import java.util.HashMap;
import java.util.MissingResourceException;

class ICUResourceBundleImpl {
    ICUResourceBundleImpl() {
    }

    static final class ResourceArray
    extends ICUResourceBundle {
        protected String[] handleGetStringArray() {
            String[] strings = new String[this.size];
            UResourceBundleIterator iter = this.getIterator();
            int i = 0;
            while (iter.hasNext()) {
                strings[i++] = iter.next().getString();
            }
            return strings;
        }

        public String[] getStringArray() {
            return this.handleGetStringArray();
        }

        protected UResourceBundle handleGet(String index, HashMap table, UResourceBundle requested) {
            int val = ICUResourceBundle.getIndex(index);
            if (val > -1) {
                return this.handleGet(val, table, requested);
            }
            throw new UResourceTypeMismatchException("Could not get the correct value for index: " + index);
        }

        protected UResourceBundle handleGet(int index, HashMap table, UResourceBundle requested) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int itemOffset = offset + ICUResourceBundle.getIntOffset(index + 1);
            long itemResource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, itemOffset);
            String path = this.isTopLevel ? Integer.toString(index) : String.valueOf(this.resPath) + "/" + index;
            return this.createBundleObject(null, itemResource, path, table, requested, this);
        }

        private int countItems() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int value = ICUResourceBundle.getInt(this.rawData, offset);
            return value;
        }

        ResourceArray(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.resource = resource;
            this.key = key;
            this.size = this.countItems();
            this.resPath = resPath;
        }
    }

    static final class ResourceBinary
    extends ICUResourceBundle {
        private byte[] value;

        public ByteBuffer getBinary() {
            return ByteBuffer.wrap(this.value);
        }

        public byte[] getBinary(byte[] ba) {
            return this.value;
        }

        private byte[] getValue() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundle.getInt(this.rawData, offset);
            int byteOffset = offset + ICUResourceBundle.getIntOffset(1);
            byte[] dst = new byte[length];
            System.arraycopy(this.rawData, byteOffset, dst, 0, length);
            return dst;
        }

        ResourceBinary(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.resource = resource;
            this.key = key;
            this.resPath = resPath;
            this.value = this.getValue();
        }
    }

    static final class ResourceInt
    extends ICUResourceBundle {
        public int getInt() {
            return ICUResourceBundle.RES_GET_INT(this.resource);
        }

        public int getUInt() {
            long ret = ICUResourceBundle.RES_GET_UINT(this.resource);
            return (int)ret;
        }

        ResourceInt(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }
    }

    static final class ResourceIntVector
    extends ICUResourceBundle {
        private int[] value;

        public int[] getIntVector() {
            return this.value;
        }

        private int[] getValue() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundle.getInt(this.rawData, offset);
            int intOffset = offset + ICUResourceBundle.getIntOffset(1);
            int[] val = new int[length];
            ICUResourceBundle.getIntOffset(length);
            int i = 0;
            while (i < length) {
                val[i] = ICUResourceBundle.getInt(this.rawData, intOffset + ICUResourceBundle.getIntOffset(i));
                ++i;
            }
            return val;
        }

        ResourceIntVector(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.key = key;
            this.resource = resource;
            this.size = 1;
            this.resPath = resPath;
            this.value = this.getValue();
        }
    }

    static final class ResourceString
    extends ICUResourceBundle {
        private String value;

        public String getString() {
            return this.value;
        }

        ResourceString(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.value = this.getStringValue(resource);
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }
    }

    static final class ResourceTable
    extends ICUResourceBundle {
        protected UResourceBundle handleGet(String key, HashMap table, UResourceBundle requested) {
            if (this.size <= 0) {
                return null;
            }
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundle.getCharOffset(1);
            int foundOffset = this.findKey(this.size, currentOffset, this, key);
            if (foundOffset == -1) {
                return null;
            }
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ICUResourceBundle.getCharOffset(this.size + (~this.size & 1)) + ICUResourceBundle.getIntOffset(foundOffset));
            String path = this.isTopLevel ? key : String.valueOf(this.resPath) + "/" + key;
            return this.createBundleObject(key, resource, path, table, requested, this);
        }

        public String getKey(int currentOffset, int index) {
            int charOffset = currentOffset + ICUResourceBundle.getCharOffset(index);
            char keyOffset = ICUResourceBundle.getChar(this.rawData, charOffset);
            return ICUResourceBundle.RES_GET_KEY(this.rawData, keyOffset).toString();
        }

        protected UResourceBundle handleGet(int index, HashMap table, UResourceBundle requested) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundle.getCharOffset(1);
            String itemKey = this.getKey(currentOffset, index);
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ICUResourceBundle.getCharOffset(this.size + (~this.size & 1)) + ICUResourceBundle.getIntOffset(index));
            String path = this.isTopLevel ? Integer.toString(index) : String.valueOf(this.resPath) + "/" + index;
            return this.createBundleObject(itemKey, resource, path, table, requested, this);
        }

        private int countItems() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            char value = ICUResourceBundle.getChar(this.rawData, offset);
            return value;
        }

        ResourceTable(String key, String resPath, long resource, ICUResourceBundle bundle) {
            this(key, resPath, resource, bundle, false);
        }

        ResourceTable(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
            this.rawData = reader.getData();
            this.rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
            this.noFallback = reader.getNoFallback();
            this.baseName = baseName;
            this.localeID = localeID;
            this.ulocale = new ULocale(localeID);
            this.loader = loader;
            this.initialize(null, "", this.rootResource, null, this.isTopLevel);
        }

        void initialize(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            if (bundle != null) {
                ICUResourceBundle.assign(this, bundle);
            }
            this.key = key;
            this.resource = resource;
            this.isTopLevel = isTopLevel;
            this.size = this.countItems();
            this.resPath = resPath;
        }

        ResourceTable(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            this.initialize(key, resPath, resource, bundle, isTopLevel);
        }
    }

    static final class ResourceTable32
    extends ICUResourceBundle {
        protected UResourceBundle handleGet(String key, HashMap table, UResourceBundle requested) {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundle.getIntOffset(1);
            int foundOffset = this.findKey(this.size, currentOffset, this, key);
            if (foundOffset == -1) {
                throw new MissingResourceException("Could not find resource ", ICUResourceBundleReader.getFullName(this.baseName, this.localeID), key);
            }
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ICUResourceBundle.getIntOffset(this.size) + ICUResourceBundle.getIntOffset(foundOffset));
            String path = this.isTopLevel ? key : String.valueOf(this.resPath) + "/" + key;
            return this.createBundleObject(key, resource, path, table, requested, this);
        }

        public String getKey(int currentOffset, int index) {
            int charOffset = currentOffset + ICUResourceBundle.getIntOffset(index);
            int keyOffset = ICUResourceBundle.getInt(this.rawData, charOffset);
            return ICUResourceBundle.RES_GET_KEY(this.rawData, keyOffset).toString();
        }

        protected UResourceBundle handleGet(int index, HashMap table, UResourceBundle requested) {
            if (this.size <= 0) {
                return null;
            }
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundle.getIntOffset(1) + ICUResourceBundle.getIntOffset(index);
            String itemKey = this.getKey(currentOffset, 0);
            long resource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ICUResourceBundle.getIntOffset(this.size));
            String path = this.isTopLevel ? Integer.toString(index) : String.valueOf(this.resPath) + "/" + index;
            return this.createBundleObject(itemKey, resource, path, table, requested, this);
        }

        private int countItems() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int value = ICUResourceBundle.getInt(this.rawData, offset);
            return value;
        }

        ResourceTable32(String key, String resPath, long resource, ICUResourceBundle bundle) {
            this(key, resPath, resource, bundle, false);
        }

        ResourceTable32(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
            this.rawData = reader.getData();
            this.rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
            this.noFallback = reader.getNoFallback();
            this.baseName = baseName;
            this.localeID = localeID;
            this.ulocale = new ULocale(localeID);
            this.loader = loader;
            this.initialize(null, "", this.rootResource, null, this.isTopLevel);
        }

        void initialize(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            if (bundle != null) {
                ICUResourceBundle.assign(this, bundle);
            }
            this.key = key;
            this.resource = resource;
            this.isTopLevel = isTopLevel;
            this.size = this.countItems();
            this.resPath = resPath;
        }

        ResourceTable32(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            this.initialize(key, resPath, resource, bundle, isTopLevel);
        }
    }
}

