/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.report.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.jboss.bpm.report.BirtService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirtUtil {
    private static final Log log = LogFactory.getLog(BirtService.class);

    public static HashMap<String, Serializable> loadParameterDetails(IGetParameterDefinitionTask task, IScalarParameterDefn scalar, IReportRunnable report, IParameterGroupDefn group) {
        HashMap<String, Serializable> parameter = new HashMap<String, Serializable>();
        if (group == null) {
            parameter.put("Parameter Group", (Serializable)((Object)"Default"));
        } else {
            parameter.put("Parameter Group", (Serializable)((Object)group.getName()));
        }
        parameter.put("Name", (Serializable)((Object)scalar.getName()));
        parameter.put("Help Text", (Serializable)((Object)scalar.getHelpText()));
        parameter.put("Display Name", (Serializable)((Object)scalar.getDisplayName()));
        parameter.put("Display Format", (Serializable)((Object)scalar.getDisplayFormat()));
        if (scalar.isHidden()) {
            parameter.put("Hidden", (Serializable)((Object)"Yes"));
        } else {
            parameter.put("Hidden", (Serializable)((Object)"No"));
        }
        if (scalar.allowBlank()) {
            parameter.put("Allow Blank", (Serializable)((Object)"Yes"));
        } else {
            parameter.put("Allow Blank", (Serializable)((Object)"No"));
        }
        if (scalar.allowNull()) {
            parameter.put("Allow Null", (Serializable)((Object)"Yes"));
        } else {
            parameter.put("Allow Null", (Serializable)((Object)"No"));
        }
        if (scalar.isValueConcealed()) {
            parameter.put("Conceal Entry", (Serializable)((Object)"Yes"));
        } else {
            parameter.put("Conceal Entry", (Serializable)((Object)"No"));
        }
        switch (scalar.getControlType()) {
            case 0: {
                parameter.put("Type", (Serializable)((Object)"TEXTBOX"));
                break;
            }
            case 1: {
                parameter.put("Type", (Serializable)((Object)"LISTBOX"));
                break;
            }
            case 2: {
                parameter.put("Type", (Serializable)((Object)"RADIO_BUTTON"));
                break;
            }
            case 3: {
                parameter.put("Type", (Serializable)((Object)"CHECKBOX"));
                break;
            }
            default: {
                parameter.put("Type", (Serializable)((Object)"TEXTBOX"));
            }
        }
        switch (scalar.getDataType()) {
            case 1: {
                parameter.put("DataType", (Serializable)((Object)"STRING"));
                break;
            }
            case 2: {
                parameter.put("DataType", (Serializable)((Object)"NUMBER"));
                break;
            }
            case 3: {
                parameter.put("DataType", (Serializable)((Object)"NUMBER"));
                break;
            }
            case 4: {
                parameter.put("DataType", (Serializable)((Object)"DATETIME"));
                break;
            }
            case 5: {
                parameter.put("DataType", (Serializable)((Object)"BOOLEAN"));
                break;
            }
            case 7: {
                parameter.put("DataType", (Serializable)((Object)"DATETIME"));
                break;
            }
            default: {
                parameter.put("DataType", (Serializable)((Object)"ANY"));
            }
        }
        ReportDesignHandle reportHandle = (ReportDesignHandle)report.getDesignHandle();
        ScalarParameterHandle parameterHandle = (ScalarParameterHandle)reportHandle.findParameter(scalar.getName());
        parameter.put("Default Value", (Serializable)((Object)parameterHandle.getDefaultValue()));
        parameter.put("Prompt Text", (Serializable)((Object)parameterHandle.getPromptText()));
        parameter.put("Data Set Expression", (Serializable)((Object)parameterHandle.getValueExpr()));
        if (scalar.getControlType() != 0) {
            if (parameterHandle.getContainer() instanceof CascadingParameterGroupHandle) {
                Collection sList = Collections.EMPTY_LIST;
                if (parameterHandle.getContainer() instanceof CascadingParameterGroupHandle) {
                    int index = parameterHandle.getContainerSlotHandle().findPosn((DesignElementHandle)parameterHandle);
                    Object[] keyValue = new Object[index];
                    for (int i = 0; i < index; ++i) {
                        ScalarParameterHandle handle = (ScalarParameterHandle)((CascadingParameterGroupHandle)parameterHandle.getContainer()).getParameters().get(i);
                        keyValue[i] = handle.getDefaultValue();
                    }
                    String groupName = parameterHandle.getContainer().getName();
                    task.evaluateQuery(groupName);
                    sList = task.getSelectionListForCascadingGroup(groupName, keyValue);
                    HashMap<Object, String> dynamicList = new HashMap<Object, String>();
                    for (IParameterSelectionChoice sI : sList) {
                        Object value = sI.getValue();
                        String label = sI.getLabel();
                        log.debug((Object)(label + "--" + value));
                        dynamicList.put(value, label);
                    }
                    parameter.put("Selection List", dynamicList);
                }
            } else {
                Collection selectionList = task.getSelectionList(scalar.getName());
                if (selectionList != null) {
                    HashMap<Object, String> dynamicList = new HashMap<Object, String>();
                    for (IParameterSelectionChoice selectionItem : selectionList) {
                        Object value = selectionItem.getValue();
                        String label = selectionItem.getLabel();
                        dynamicList.put(value, label);
                    }
                    parameter.put("Selection List", dynamicList);
                }
            }
        }
        Iterator iter = parameter.keySet().iterator();
        log.debug((Object)("======================Parameter =" + scalar.getName()));
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (name.equals("Selection List")) {
                HashMap selList = (HashMap)parameter.get(name);
                for (Object lbl : selList.keySet()) {
                    log.debug((Object)("Selection List Entry ===== Key = " + lbl + " Value = " + selList.get(lbl)));
                }
                continue;
            }
            log.debug((Object)(name + " = " + parameter.get(name)));
        }
        return parameter;
    }
}

