/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.reflections.ReflectionsException;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClasspathHelper {
    public static Set<URL> getUrlsForPackagePrefix(String packagePrefix) {
        try {
            Enumeration<URL> urlEnumeration = Utils.getContextClassLoader().getResources(packagePrefix.replace(".", "/"));
            ArrayList urls = Lists.newArrayList((Iterator)Iterators.forEnumeration(urlEnumeration));
            return ClasspathHelper.getBaseUrls(urls, ClasspathHelper.getUrlsForCurrentClasspath());
        }
        catch (IOException e) {
            throw new ReflectionsException("Can't resolve URL for package prefix " + packagePrefix, e);
        }
    }

    public static Set<URL> getUrlsForCurrentClasspath() {
        String javaClassPath;
        HashSet urls = Sets.newHashSet();
        for (ClassLoader loader = Utils.getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            Collections.addAll(urls, ((URLClassLoader)loader).getURLs());
        }
        if (urls.isEmpty() && (javaClassPath = System.getProperty("java.class.path")) != null) {
            for (String path : javaClassPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(path).toURI().toURL());
                }
                catch (Exception e) {
                    throw new ReflectionsException("could not create url from " + path, e);
                }
            }
        }
        return ImmutableSet.copyOf((Iterable)urls);
    }

    public static Set<URL> getUrlsForWebInfLib(ServletContext servletContext) {
        HashSet urls = Sets.newHashSet();
        for (Object urlString : servletContext.getResourcePaths("/WEB-INF/lib")) {
            try {
                urls.add(servletContext.getResource((String)urlString));
            }
            catch (MalformedURLException e) {}
        }
        return urls;
    }

    public static URL getUrlForServletContextClasses(ServletContext servletContext) {
        try {
            String path = servletContext.getRealPath("/WEB-INF/classes");
            File file = new File(path);
            if (file.exists()) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static Set<URL> getUrlsForManifestsCurrentClasspath() {
        return ClasspathHelper.getUrlsForManifests(ClasspathHelper.getUrlsForCurrentClasspath());
    }

    public static Set<URL> getUrlsForManifests(Set<URL> urls) {
        HashSet manifestUrls = Sets.newHashSet();
        for (URL url : urls) {
            manifestUrls.addAll(ClasspathHelper.getUrlsForManifest(url));
        }
        return ImmutableSet.copyOf((Iterable)manifestUrls);
    }

    public static Set<URL> getUrlsForManifest(URL url) {
        HashSet javaClassPath = Sets.newHashSet();
        javaClassPath.add(url);
        try {
            String classPath;
            Manifest manifest;
            String part = Vfs.normalizePath(url.getFile());
            File jarFile = new File(part);
            JarFile myJar = new JarFile(part);
            URL validUrl = ClasspathHelper.tryToGetValidUrl(jarFile.getPath(), new File(part).getParent(), part);
            if (validUrl != null) {
                javaClassPath.add(validUrl);
            }
            if ((manifest = myJar.getManifest()) != null && (classPath = manifest.getMainAttributes().getValue(new Attributes.Name("Class-Path"))) != null) {
                for (String jar : classPath.split(" ")) {
                    validUrl = ClasspathHelper.tryToGetValidUrl(jarFile.getPath(), new File(part).getParent(), jar);
                    if (validUrl == null) continue;
                    javaClassPath.add(validUrl);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return javaClassPath;
    }

    private static URL tryToGetValidUrl(String workingDir, String path, String filename) {
        try {
            if (new File(filename).exists()) {
                return new File(filename).toURL();
            }
            if (new File(path + File.separator + filename).exists()) {
                return new File(path + File.separator + filename).toURL();
            }
            if (new File(workingDir + File.separator + filename).exists()) {
                return new File(workingDir + File.separator + filename).toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static URL getUrlForClass(Class<?> aClass) {
        String resourceName = aClass.getName().replace(".", "/") + ".class";
        URL packageUrl = Utils.getContextClassLoader().getResource(resourceName);
        if (packageUrl != null) {
            return ClasspathHelper.getBaseUrl(packageUrl, ClasspathHelper.getUrlsForCurrentClasspath());
        }
        return null;
    }

    public static URL getBaseUrl(URL url, Collection<URL> baseUrls) {
        if (url != null) {
            String path1 = Vfs.normalizePath(url);
            for (URL baseUrl : baseUrls) {
                String path2 = Vfs.normalizePath(baseUrl);
                if (!path1.startsWith(path2)) continue;
                return baseUrl;
            }
        }
        return url;
    }

    public static URL getBaseUrl(URL url) {
        return ClasspathHelper.getBaseUrl(url, ClasspathHelper.getUrlsForCurrentClasspath());
    }

    public static Set<URL> getBaseUrls(List<URL> urls, Collection<URL> baseUrls) {
        HashSet result = Sets.newHashSet();
        for (URL url : urls) {
            result.add(ClasspathHelper.getBaseUrl(url, baseUrls));
        }
        return result;
    }
}

