/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.report;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.jboss.bpm.report.BirtEngineFactory;
import org.jboss.bpm.report.IntegrationConfig;
import org.jboss.bpm.report.RenderMetaData;
import org.jboss.bpm.report.model.ReportParameter;
import org.jboss.bpm.report.model.ReportReference;
import org.jboss.bpm.report.util.BirtUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirtService {
    private static final Log log = LogFactory.getLog(BirtService.class);
    private IReportEngine engine;
    private IntegrationConfig iConfig;
    private State currentState = State.NONE;
    private Map<String, IReportRunnable> cache = new ConcurrentHashMap<String, IReportRunnable>();
    private Map<String, ReportReference> reports = new ConcurrentHashMap<String, ReportReference>();

    public BirtService(IntegrationConfig iConfig) {
        this.iConfig = iConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() {
        if (this.currentState != State.NONE) {
            throw new IllegalStateException("Service already in state " + (Object)((Object)this.currentState));
        }
        Map<String, ReportReference> map = this.reports;
        synchronized (map) {
            this.engine = BirtEngineFactory.newInstance(this.iConfig);
            File workDir = new File(this.iConfig.getReportDir());
            if (!workDir.exists()) {
                throw new IllegalStateException("Working directory " + this.iConfig.getReportDir() + " cannot be found!");
            }
            try {
                this.loadReports();
                this.extractParameterMetaData();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load reports", e);
            }
            log.info((Object)("Service created: " + this.engine));
            this.currentState = State.CREATED;
        }
    }

    private void loadReports() {
        File[] reportFiles;
        File workDir = new File(this.iConfig.getReportDir());
        assert (workDir.isDirectory());
        for (File f : reportFiles = workDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".rptdesign");
            }
        })) {
            this.reports.put(f.getName(), new ReportReference(f.getName()));
        }
    }

    private void extractParameterMetaData() throws EngineException {
        for (String templateName : this.reports.keySet()) {
            IReportRunnable template = this.openCached(templateName);
            String title = BirtService.nonNull((String)template.getProperty("title"), "No title");
            String description = BirtService.nonNull((String)template.getProperty("description"), "No description");
            ReportReference reportRef = this.reports.get(templateName);
            reportRef.setTitle(title);
            reportRef.setDescription(description);
            HashMap<String, HashMap<String, Serializable>> paramDetails = new HashMap<String, HashMap<String, Serializable>>();
            IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(template);
            Collection params = task.getParameterDefns(true);
            for (IParameterDefnBase param : params) {
                if (param instanceof IParameterGroupDefn) {
                    IParameterGroupDefn group = (IParameterGroupDefn)param;
                    for (IScalarParameterDefn scalar : group.getContents()) {
                        paramDetails.put(scalar.getName(), BirtUtil.loadParameterDetails(task, scalar, template, group));
                    }
                } else {
                    IScalarParameterDefn scalar = (IScalarParameterDefn)param;
                    paramDetails.put(scalar.getName(), BirtUtil.loadParameterDetails(task, scalar, template, null));
                }
                task.close();
            }
            ReportReference ref = this.reports.get(templateName);
            Iterator paramNames = paramDetails.keySet().iterator();
            while (paramNames.hasNext()) {
                Map map = (Map)paramDetails.get(paramNames.next());
                ReportParameter paramRef = new ReportParameter((String)map.get("Name"), ReportParameter.Type.valueOf((String)((String)map.get("Type"))));
                paramRef.setDataType(ReportParameter.DataType.valueOf((String)((String)map.get("DataType"))));
                paramRef.setHelptext((String)map.get("Help Text"));
                paramRef.setPromptText((String)map.get("Prompt Text"));
                ref.getParameterMetaData().add(paramRef);
            }
        }
    }

    private static String nonNull(String candidate, String defaultValue) {
        return candidate != null ? candidate : defaultValue;
    }

    public void createAsync() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                log.info((Object)"Creating BIRT service in the background");
                BirtService.this.create();
            }
        });
        t.setName("BirtService-Init");
        t.start();
    }

    public void start() {
        if (this.currentState != State.CREATED) {
            throw new IllegalStateException("Please call create lifecylce before starting the service");
        }
        this.currentState = State.STARTED;
    }

    public void stop() {
        if (this.currentState != State.STARTED) {
            throw new IllegalStateException("Please call start lifecylce before stopping the service");
        }
        this.currentState = State.STOPPED;
    }

    public void destroy() {
        if (this.engine != null) {
            this.engine.destroy();
        }
        Platform.shutdown();
        log.info((Object)"Service destroyed");
        this.currentState = State.DESTROYED;
    }

    public String render(RenderMetaData metaData) {
        if (!(this.currentState == State.CREATED || this.currentState == State.STARTED)) {
            throw new IllegalStateException("Cannot render in state " + (Object)((Object)this.currentState));
        }
        if (!this.reports.keySet().contains(metaData.getReportName())) {
            throw new IllegalArgumentException("No such report template: " + metaData.getReportName());
        }
        String outputFileName = null;
        log.debug((Object)("Render " + metaData));
        IRunTask task = null;
        try {
            IReportRunnable design = this.openCached(metaData.getReportName());
            task = this.engine.createRunTask(design);
            outputFileName = metaData.getReportName() + ".rptdocument";
            task.getAppContext().put("PARENT_CLASSLOADER", metaData.getClassloader());
            task.setParameterValues(this.unmarshalParameters(metaData));
            task.run(this.iConfig.getOutputDir() + outputFileName);
        }
        catch (EngineException e) {
            throw new RuntimeException("Failed to render report: " + e.getMessage(), e);
        }
        finally {
            if (task != null) {
                task.close();
            }
        }
        return outputFileName;
    }

    private Map<String, Object> unmarshalParameters(RenderMetaData metaData) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String paramName : metaData.getParameters().keySet()) {
            try {
                ReportReference reportRef = this.reports.get(metaData.getReportName());
                ReportParameter reportParam = reportRef.getParameter(paramName);
                if (null == paramName) {
                    throw new IllegalArgumentException("No such param " + paramName);
                }
                String paramValue = metaData.getParameters().get(paramName);
                switch (reportParam.getDataType()) {
                    case DATETIME: {
                        results.put(paramName, new Date(new SimpleDateFormat("yyyy-MM-dd").parse(paramValue).getTime()));
                        break;
                    }
                    case NUMBER: {
                        results.put(paramName, Long.valueOf(paramValue));
                        break;
                    }
                    case BOOLEAN: {
                        results.put(paramName, Boolean.valueOf(paramValue));
                        break;
                    }
                    default: {
                        results.put(paramName, paramValue);
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to unmarshall report parameter", e);
            }
        }
        return results;
    }

    public String view(RenderMetaData metaData) {
        if (!(this.currentState == State.CREATED || this.currentState == State.STARTED)) {
            throw new IllegalStateException("Cannot renderTask in state " + (Object)((Object)this.currentState));
        }
        if (!this.reports.keySet().contains(metaData.getReportName())) {
            throw new IllegalArgumentException("No such report template: " + metaData.getReportName());
        }
        String outputFileName = null;
        log.debug((Object)("View " + metaData));
        IRenderTask renderTask = null;
        try {
            IReportDocument document = this.engine.openReportDocument(this.iConfig.getOutputDir() + metaData.getReportName() + ".rptdocument");
            renderTask = this.engine.createRenderTask(document);
            renderTask.getAppContext().put("PARENT_CLASSLOADER", metaData.getClassloader());
            renderTask.setParameterValues(metaData.getParameters());
            RenderOption options = new RenderOption();
            switch (metaData.getFormat()) {
                case HTML: {
                    options.setOutputFormat("html");
                    outputFileName = BirtService.extactReportName(metaData.getReportName()) + ".html";
                    break;
                }
                case PDF: {
                    options.setOutputFormat("pdf");
                    outputFileName = BirtService.extactReportName(metaData.getReportName()) + ".pdf";
                }
            }
            options.setOutputFileName(this.iConfig.getOutputDir() + outputFileName);
            if (options.getOutputFormat().equalsIgnoreCase("html")) {
                HTMLRenderOption htmlOptions = new HTMLRenderOption((IRenderOption)options);
                htmlOptions.setImageHandler((IHTMLImageHandler)new HTMLServerImageHandler());
                htmlOptions.setImageDirectory(this.iConfig.getImageDirectory());
                htmlOptions.setBaseImageURL(metaData.getImageBaseUrl());
                htmlOptions.setHtmlPagination(false);
                htmlOptions.setHtmlRtLFlag(false);
                htmlOptions.setEmbeddable(false);
                renderTask.setRenderOption((IRenderOption)htmlOptions);
            } else if (options.getOutputFormat().equalsIgnoreCase("pdf")) {
                PDFRenderOption pdfOptions = new PDFRenderOption((IRenderOption)options);
                pdfOptions.setOption("pdfRenderOption.fitToPage", (Object)new Boolean(true));
                pdfOptions.setOption("pdfRenderOption.pagebreakPaginationOnly", (Object)new Boolean(true));
                renderTask.setRenderOption((IRenderOption)pdfOptions);
            }
            if (renderTask.getRenderOption() == null) {
                renderTask.setRenderOption((IRenderOption)options);
            }
            renderTask.render();
        }
        catch (EngineException e) {
            throw new RuntimeException("Failed to renderTask report: " + e.getMessage(), e);
        }
        finally {
            if (renderTask != null) {
                renderTask.close();
            }
        }
        return outputFileName;
    }

    private IReportRunnable openCached(String reportName) throws EngineException {
        IReportRunnable design = this.cache.get(reportName);
        if (null == design) {
            design = this.engine.openReportDesign(this.iConfig.getReportDir() + reportName);
            this.cache.put(reportName, design);
        }
        return design;
    }

    public IntegrationConfig getIntegrationConfig() {
        return this.iConfig;
    }

    private static String extactReportName(String reportFile) {
        return reportFile.substring(0, reportFile.indexOf("."));
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public List<ReportReference> getReportReferences() {
        if (!(this.currentState == State.CREATED || this.currentState == State.STARTED)) {
            throw new IllegalStateException("Cannot acccess report references in state " + (Object)((Object)this.currentState));
        }
        ArrayList<ReportReference> list = new ArrayList<ReportReference>();
        for (String s : this.reports.keySet()) {
            list.add(this.reports.get(s));
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NONE,
        CREATED,
        STARTED,
        STOPPED,
        DESTROYED;

    }
}

