/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.report;

import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.bpm.report.BirtService;
import org.jboss.bpm.report.IntegrationConfig;
import org.jboss.bpm.report.JMXServerConfig;
import org.jboss.bpm.report.RenderMetaData;
import org.jboss.bpm.report.model.ReportReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="report")
public class ReportFacade {
    private static final Log log = LogFactory.getLog(ReportFacade.class);
    private BirtService birtService;
    private boolean isInitialized;
    private boolean initAttempt;

    public ReportFacade() {
        try {
            if (!this.initAttempt) {
                this.initBirtService();
            }
        }
        catch (BirtInitException e) {
            this.initAttempt = true;
            log.warn((Object)"Failed to initialize BIRT service. Please check the DEBUG log for further details.");
            log.debug((Object)"Initialization failed", (Throwable)e);
        }
    }

    public void initBirtService() throws BirtInitException {
        if (!this.isInitialized) {
            String absServerDataDir;
            File serverDataDir = this.resolveBirtDataDir();
            IntegrationConfig iConfig = new IntegrationConfig();
            String birtDataDir = absServerDataDir = serverDataDir.getAbsolutePath();
            String defaultBirtHome = birtDataDir + "/ReportEngine";
            String birtOutputDir = birtDataDir + "/output";
            File birtOutput = new File(birtOutputDir);
            birtOutput.mkdirs();
            if (!new File(defaultBirtHome).exists()) {
                throw new BirtInitException("The BIRT report engine doesn't seem to be installed:" + defaultBirtHome);
            }
            iConfig.setBirtHome(defaultBirtHome);
            iConfig.setOutputDir(birtOutputDir);
            iConfig.setReportDir(birtDataDir);
            log.info((Object)("BIRT home: " + iConfig.getBirtHome()));
            log.info((Object)("Output dir: " + iConfig.getOutputDir()));
            log.info((Object)("Report dir: " + iConfig.getReportDir()));
            try {
                this.birtService = new BirtService(iConfig);
                this.birtService.createAsync();
            }
            catch (Throwable t) {
                throw new BirtInitException(t.getMessage(), t);
            }
            this.isInitialized = true;
        }
    }

    private File resolveBirtDataDir() {
        JMXServerConfig jmxConfig = null;
        File serverDataDir = null;
        if (System.getProperty("org.jbpm.report.engine.dir") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checks custom location defined with JVM parameter '-Dorg.jbpm.report.engine.dir' = " + System.getProperty("org.jbpm.report.engine.dir")));
            }
            if ((serverDataDir = new File(System.getProperty("org.jbpm.report.engine.dir"))) != null && serverDataDir.exists()) {
                return serverDataDir;
            }
        }
        try {
            jmxConfig = new JMXServerConfig();
            serverDataDir = new File(jmxConfig.getServerDataDir(), "birt");
        }
        catch (Exception e) {
            log.warn((Object)"Resolving serverDataDir based on -Dcatalina.home");
            if (System.getProperty("catalina.home") != null) {
                serverDataDir = new File(System.getProperty("catalina.home") + "/birt");
            }
            throw new IllegalStateException("Neither JMX config nor '-Dcatalina.home' nor '-Dorg.jbpm.report.engine.dir' available to resolve serverDataDir");
        }
        return serverDataDir;
    }

    @GET
    @Path(value="render/{fileName}")
    @Produces(value={"text/html"})
    public Response viewReportHtml(@PathParam(value="fileName") String fileName, @Context HttpServletRequest request) {
        this.assertBirtAvailability();
        try {
            RenderMetaData renderMeta = this.defaultRenderMetaData(fileName, request);
            String outputFileName = this.birtService.view(renderMeta);
            String absoluteFile = this.birtService.getIntegrationConfig().getOutputDir() + outputFileName;
            log.debug((Object)("View " + absoluteFile));
            File reportFile = new File(absoluteFile);
            return Response.ok((Object)reportFile).type("text/html").build();
        }
        catch (Throwable e1) {
            return this.gracefulException(e1);
        }
    }

    private void assertBirtAvailability() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Report server not initialized. Please check the server logs for further details.");
        }
    }

    @POST
    @Path(value="render/{fileName}")
    @Produces(value={"text/html"})
    public Response renderReportHtml(@PathParam(value="fileName") String fileName, @Context HttpServletRequest request) {
        this.assertBirtAvailability();
        try {
            RenderMetaData renderMeta = this.defaultRenderMetaData(fileName, request);
            Map<String, String> postParams = ReportFacade.convertRequestParametersToMap(request);
            renderMeta.getParameters().putAll(postParams);
            String outputFileName = this.birtService.render(renderMeta);
            String absoluteFile = this.birtService.getIntegrationConfig().getOutputDir() + outputFileName;
            log.debug((Object)("Render " + absoluteFile));
            return Response.ok().type("text/html").build();
        }
        catch (Throwable e1) {
            return this.gracefulException(e1);
        }
    }

    @GET
    @Path(value="view/image/{fileName}")
    public Response getImage(@PathParam(value="fileName") String fileName, @Context HttpServletRequest request) {
        this.assertBirtAvailability();
        String imageDir = this.birtService.getIntegrationConfig().getImageDirectory();
        String absName = imageDir + fileName;
        File imageFile = new File(absName);
        if (!imageFile.exists()) {
            throw new IllegalArgumentException("Image " + absName + " doesn't exist");
        }
        return Response.ok((Object)imageFile).build();
    }

    private RenderMetaData defaultRenderMetaData(String fileName, HttpServletRequest request) {
        RenderMetaData renderMeta = new RenderMetaData();
        renderMeta.setReportName(fileName);
        renderMeta.setFormat(RenderMetaData.Format.HTML);
        renderMeta.setClassloader(Thread.currentThread().getContextClassLoader());
        renderMeta.setImageBaseUrl(this.buildImageUrl(request));
        return renderMeta;
    }

    private String buildImageUrl(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        sb.append("http://");
        sb.append(request.getServerName()).append(":");
        sb.append(request.getServerPort());
        sb.append(request.getContextPath());
        sb.append(request.getServletPath());
        sb.append("/report/view/image");
        return sb.toString();
    }

    private Response gracefulException(Throwable e) {
        log.error((Object)"Error processing report", e);
        StringBuffer sb = new StringBuffer();
        sb.append("<div style='font-family:sans-serif; padding:10px;'>");
        sb.append("<h3>Unable to process report").append("</h3>");
        sb.append(e.getMessage());
        sb.append("</div>");
        return Response.ok((Object)sb.toString()).status(400).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> convertRequestParametersToMap(HttpServletRequest request) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        BufferedReader br = null;
        try {
            String line;
            br = request.getReader();
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, ";");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (s.indexOf("=") == -1) continue;
                    String[] tuple = s.split("=");
                    parameterMap.put(tuple[0], tuple[1]);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to parse report parameters", (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return parameterMap;
    }

    @GET
    @Path(value="config")
    @Produces(value={"application/json"})
    public Response getReportConfig() {
        this.assertBirtAvailability();
        List<ReportReference> refs = this.birtService.getReportReferences();
        String json = new GsonBuilder().create().toJson(refs);
        return Response.ok((Object)json).build();
    }

    public class BirtInitException
    extends Exception {
        public BirtInitException(String message) {
            super(message);
        }

        public BirtInitException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

