/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.gui.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwt.mosaic.ui.client.CaptionLayoutPanel;
import org.gwt.mosaic.ui.client.CollapsedListener;
import org.gwt.mosaic.ui.client.LayoutPopupPanel;
import org.gwt.mosaic.ui.client.PopupMenu;
import org.gwt.mosaic.ui.client.ToolBar;
import org.gwt.mosaic.ui.client.ToolButton;
import org.gwt.mosaic.ui.client.layout.BoxLayout;
import org.gwt.mosaic.ui.client.layout.BoxLayoutData;
import org.gwt.mosaic.ui.client.layout.ColumnLayout;
import org.gwt.mosaic.ui.client.layout.ColumnLayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutData;
import org.gwt.mosaic.ui.client.layout.LayoutManager;
import org.gwt.mosaic.ui.client.layout.LayoutPanel;
import org.gwt.mosaic.ui.client.layout.RowLayout;
import org.gwt.mosaic.ui.client.layout.RowLayoutData;
import org.gwt.mosaic.ui.client.util.ResizableWidget;
import org.gwt.mosaic.ui.client.util.ResizableWidgetCollection;
import org.jboss.bpm.monitor.gui.client.ChartData;
import org.jboss.bpm.monitor.gui.client.ChronoscopeFactory;
import org.jboss.bpm.monitor.gui.client.HistoryRecords;
import org.jboss.bpm.monitor.gui.client.JSOModel;
import org.jboss.bpm.monitor.gui.client.TimespanValues;
import org.jboss.bpm.monitor.gui.client.comments.ChartComment;
import org.jboss.bpm.monitor.gui.client.comments.CommentEditCallback;
import org.jboss.bpm.monitor.gui.client.comments.CommentPanel;
import org.jboss.errai.bus.client.api.RemoteCallback;
import org.jboss.errai.bus.client.api.base.MessageBuilder;
import org.jboss.errai.workspaces.client.api.ProvisioningCallback;
import org.jboss.errai.workspaces.client.api.WidgetProvider;
import org.jboss.errai.workspaces.client.api.annotations.LoadTool;
import org.timepedia.chronoscope.client.Dataset;
import org.timepedia.chronoscope.client.Datasets;
import org.timepedia.chronoscope.client.Overlay;
import org.timepedia.chronoscope.client.XYPlot;
import org.timepedia.chronoscope.client.browser.ChartPanel;
import org.timepedia.chronoscope.client.browser.Chronoscope;
import org.timepedia.chronoscope.client.browser.json.GwtJsonDataset;
import org.timepedia.chronoscope.client.browser.json.JsonDatasetJSO;
import org.timepedia.chronoscope.client.canvas.View;
import org.timepedia.chronoscope.client.canvas.ViewReadyCallback;
import org.timepedia.chronoscope.client.data.json.JsonDataset;
import org.timepedia.chronoscope.client.event.PlotFocusEvent;
import org.timepedia.chronoscope.client.event.PlotFocusHandler;
import org.timepedia.chronoscope.client.overlays.DomainBarMarker;

@LoadTool(name="Process Activity", group="Processes")
public class DefinitionHistoryView
implements WidgetProvider,
CommentEditCallback {
    private static final String TIMEPEDIA_FONTBOOK_SERVICE = "http://api.timepedia.org/fr";
    private static volatile double GOLDEN__RATIO = 1.618;
    private ChartPanel chartPanel;
    private ToolButton menuButton;
    private ToolButton timespanButton;
    private HTML title;
    private HTML timespan;
    private CaptionLayoutPanel chartArea;
    private LayoutPanel timespanPanel;
    private CommentPanel commentPanel;
    private Map<Long, Overlay> overlayMapping = new HashMap<Long, Overlay>();

    public void provideWidget(ProvisioningCallback callback) {
        LayoutPanel panel = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
        ToolBar toolBar = new ToolBar();
        panel.add((Widget)toolBar, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        this.menuButton = new ToolButton("Open");
        this.menuButton.setStyle(ToolButton.ToolButtonStyle.MENU);
        Command selectProcessCmd = new Command(){

            public void execute() {
                DefinitionHistoryView.this.selectDefinition();
            }
        };
        PopupMenu menuBtnMenu = new PopupMenu();
        menuBtnMenu.addItem("ProcessDefintion", selectProcessCmd);
        this.menuButton.setMenu(menuBtnMenu);
        toolBar.add((Widget)this.menuButton);
        toolBar.addSeparator();
        toolBar.add((Widget)new ToolButton("Export"));
        this.title = new HTML();
        this.title.getElement().setAttribute("style", "font-size:24px; font-weight:BOLD");
        BoxLayout boxLayout = new BoxLayout(BoxLayout.Orientation.HORIZONTAL);
        this.timespanPanel = new LayoutPanel((LayoutManager)boxLayout);
        this.timespan = new HTML();
        this.timespan.getElement().setAttribute("style", "padding-top:2px; color:#C8C8C8;font-size:16px;text-align:left;");
        this.timespanButton = new ToolButton();
        this.timespanButton.setVisible(false);
        this.timespanButton.setStyle(ToolButton.ToolButtonStyle.MENU);
        PopupMenu timeBtnMenu = new PopupMenu();
        for (final TimespanValues ts : TimespanValues.values()) {
            timeBtnMenu.addItem(ts.name(), new Command(){

                public void execute() {
                    DefinitionHistoryView.this.loadGraphData(DefinitionHistoryView.this.title.getText(), ts);
                }
            });
        }
        this.timespanButton.setMenu(timeBtnMenu);
        this.timespanPanel.add((Widget)this.timespanButton);
        this.timespanPanel.add((Widget)this.timespan, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
        final LayoutPanel contents = new LayoutPanel((LayoutManager)new RowLayout());
        LayoutPanel headerPanel = new LayoutPanel((LayoutManager)new ColumnLayout());
        headerPanel.add((Widget)this.title, (LayoutData)new ColumnLayoutData("50%"));
        headerPanel.add((Widget)this.timespanPanel, (LayoutData)new ColumnLayoutData("50%"));
        this.chartArea = new CaptionLayoutPanel();
        this.chartArea.setPadding(15);
        contents.add((Widget)headerPanel, (LayoutData)new RowLayoutData("120"));
        contents.add((Widget)this.chartArea, (LayoutData)new RowLayoutData(true));
        this.commentPanel = new CommentPanel(this);
        this.commentPanel.addCollapsedListener(new CollapsedListener(){

            public void onCollapsedChange(Widget sender) {
                DefinitionHistoryView.this.commentPanel.toogleListView();
                contents.layout();
            }
        });
        contents.add((Widget)this.commentPanel, (LayoutData)new RowLayoutData("80"));
        panel.add((Widget)contents, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.BOTH));
        callback.onSuccess((Widget)panel);
    }

    private void selectDefinition() {
        HistoryRecords rpcService = (HistoryRecords)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<List<String>>(){

            public void callback(List<String> response) {
                final LayoutPopupPanel popup = new LayoutPopupPanel(false);
                popup.addStyleName("soa-PopupPanel");
                final ListBox listBox = new ListBox();
                listBox.addItem("");
                for (String s : response) {
                    listBox.addItem(s);
                }
                LayoutPanel p = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.VERTICAL));
                p.add((Widget)new HTML("Which definition would like to inspect?"));
                p.add((Widget)listBox);
                LayoutPanel p2 = new LayoutPanel((LayoutManager)new BoxLayout(BoxLayout.Orientation.HORIZONTAL));
                p2.add((Widget)new Button("Done", new ClickHandler(){

                    public void onClick(ClickEvent clickEvent) {
                        if (listBox.getSelectedIndex() > 0) {
                            popup.hide();
                            String procDef = listBox.getItemText(listBox.getSelectedIndex());
                            DefinitionHistoryView.this.title.setText(procDef);
                            DefinitionHistoryView.this.loadGraphData(procDef, TimespanValues.LAST_7_DAYS);
                        }
                    }
                }));
                HTML html = new HTML("Cancel");
                html.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent clickEvent) {
                        popup.hide();
                    }
                });
                p2.add((Widget)html, (LayoutData)new BoxLayoutData(BoxLayoutData.FillStyle.HORIZONTAL));
                p.add((Widget)p2);
                popup.setPopupPosition(DefinitionHistoryView.this.menuButton.getAbsoluteLeft() - 5, DefinitionHistoryView.this.menuButton.getAbsoluteTop() + 30);
                popup.setWidget((Widget)p);
                popup.pack();
                popup.show();
            }
        }, HistoryRecords.class);
        rpcService.getProcessDefinitionKeys();
    }

    private void loadGraphData(String procDefID, TimespanValues timespan) {
        ChartData rpcService = (ChartData)MessageBuilder.createCall((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String response) {
                DefinitionHistoryView.this.timespanButton.setVisible(true);
                DefinitionHistoryView.this.renderChart(response);
                DefinitionHistoryView.this.timespanPanel.layout();
            }
        }, ChartData.class);
        rpcService.getCompletedInstances(procDefID, timespan.name());
    }

    public void onSaveComment(ChartComment comment) {
        XYPlot plot = this.chartPanel.getChart().getPlot();
        DomainBarMarker marker = new DomainBarMarker(comment.getDomainValue(), 1.0, comment.getTitle());
        plot.addOverlay((Overlay)marker);
        plot.redraw();
        this.overlayMapping.put(comment.getId(), (Overlay)marker);
    }

    public void onCancelComment(ChartComment comment) {
    }

    public void onDeleteComment(ChartComment comment) {
        Overlay marker = this.overlayMapping.get(comment.getId());
        XYPlot plot = this.chartPanel.getChart().getPlot();
        plot.removeOverlay(marker);
        plot.redraw();
        this.resizeChartView();
    }

    public void onHighlightComment(ChartComment comment) {
    }

    private void renderChart(String jsonData) {
        try {
            Datasets datasets = new Datasets();
            datasets.add(ChronoscopeFactory.getInstance().getDatasetReader().createDatasetFromJson((JsonDataset)new GwtJsonDataset((JavaScriptObject)JSOModel.fromJson(jsonData))));
            Dataset[] dsArray = datasets.toArray();
            if (this.chartPanel != null) {
                this.chartArea.remove((Widget)this.chartPanel);
                this.commentPanel.reset();
                this.overlayMapping.clear();
            }
            this.initChartPanel(dsArray);
            this.chartArea.layout();
        }
        catch (Exception e) {
            GWT.log((String)"Failed to create chart", (Throwable)e);
        }
    }

    private void initChartPanel(Dataset[] datasets) {
        int[] dim = this.calcChartDimension();
        this.chartPanel = Chronoscope.createTimeseriesChart((Dataset[])datasets, (int)dim[0], (int)dim[1]);
        XYPlot plot = this.chartPanel.getChart().getPlot();
        plot.addPlotFocusHandler(new PlotFocusHandler(){

            public void onFocus(PlotFocusEvent event) {
                if (event.getFocusDataset() >= 0) {
                    ChartComment comment = new ChartComment();
                    comment.setDomainValue(event.getDomain());
                    DefinitionHistoryView.this.commentPanel.toogleEditView(comment);
                }
            }
        });
        this.timespan.setText(datasets[0].getRangeLabel());
        this.chartPanel.setViewReadyCallback(new ViewReadyCallback(){

            public void onViewReady(View view) {
                DefinitionHistoryView.this.resizeChartArea(view);
            }
        });
        this.chartArea.add((Widget)this.chartPanel);
        ResizableWidgetCollection.get().add(new ResizableWidget(){

            public Element getElement() {
                return DefinitionHistoryView.this.chartPanel.getElement();
            }

            public boolean isAttached() {
                return DefinitionHistoryView.this.chartPanel.isAttached();
            }

            public void onResize(int width, int height) {
                View view = DefinitionHistoryView.this.resizeChartView();
            }
        });
    }

    private int[] calcChartDimension() {
        int w = this.chartArea.getOffsetWidth() / 2;
        int h = (int)((double)w / GOLDEN__RATIO);
        return new int[]{w, h};
    }

    private View resizeChartView() {
        int[] dim = this.calcChartDimension();
        View view = this.chartPanel.getChart().getView();
        if (view != null) {
            view.resize(dim[0], dim[1]);
        }
        this.resizeChartArea(view);
        return view;
    }

    private void resizeChartArea(View view) {
        int resizeTo = Integer.valueOf(view.getHeight()) + 75;
        this.chartArea.setHeight(resizeTo + "px");
        this.chartArea.layout();
    }

    private static native JsonDatasetJSO getJson(String var0);
}

