/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonArrayDeserializationVisitor;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonObjectDeserializationVisitor;
import com.google.gson.JsonPrimitive;
import com.google.gson.ObjectConstructor;
import com.google.gson.ObjectNavigator;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeUtils;
import java.lang.reflect.Type;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsonDeserializationVisitor<T>
implements ObjectNavigator.Visitor {
    protected static Logger logger = Logger.getLogger(JsonDeserializationVisitor.class.getName());
    protected final ObjectNavigatorFactory factory;
    protected final ObjectConstructor objectConstructor;
    protected final TypeAdapter typeAdapter;
    protected final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    protected T target;
    protected final JsonElement json;
    protected final Type targetType;
    private final JsonDeserializationContext context;

    public JsonDeserializationVisitor(JsonElement json, Type targetType, ObjectNavigatorFactory factory, ObjectConstructor objectConstructor, TypeAdapter typeAdapter, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, JsonDeserializationContext context) {
        Preconditions.checkNotNull(json);
        this.targetType = targetType;
        this.factory = factory;
        this.objectConstructor = objectConstructor;
        this.typeAdapter = typeAdapter;
        this.deserializers = deserializers;
        this.json = json;
        this.context = context;
    }

    T getTarget() {
        if (this.target == null) {
            this.target = this.constructTarget();
        }
        return this.target;
    }

    protected abstract T constructTarget();

    @Override
    public final void visitEnum(Object obj, Type objType) {
        JsonDeserializer<?> deserializer = this.deserializers.getHandlerFor(objType);
        if (deserializer == null) {
            deserializer = this.deserializers.getHandlerFor((Type)((Object)Enum.class));
        }
        if (deserializer == null) {
            throw new RuntimeException("Register a JsonDeserializer for Enum or " + obj.getClass().getName());
        }
        this.target = deserializer.deserialize(this.json, objType, this.context);
    }

    @Override
    public final boolean visitUsingCustomHandler(Object obj, Type objType) {
        JsonDeserializer<?> deserializer = this.deserializers.getHandlerFor(objType);
        if (deserializer != null) {
            this.target = deserializer.deserialize(this.json, objType, this.context);
            return true;
        }
        return false;
    }

    final Object visitChildAsObject(Type childType, JsonElement jsonChild) {
        JsonObjectDeserializationVisitor childVisitor = new JsonObjectDeserializationVisitor(jsonChild, childType, this.factory, this.objectConstructor, this.typeAdapter, this.deserializers, this.context);
        return this.visitChild(childType, childVisitor);
    }

    final Object visitChildAsArray(Type childType, JsonArray jsonChild) {
        JsonArrayDeserializationVisitor childVisitor = new JsonArrayDeserializationVisitor(jsonChild.getAsJsonArray(), childType, this.factory, this.objectConstructor, this.typeAdapter, this.deserializers, this.context);
        return this.visitChild(childType, childVisitor);
    }

    final Object visitChildAsPrimitive(Type childType, JsonPrimitive jsonChild) {
        Preconditions.checkNotNull(jsonChild);
        Class<?> childClass = childType instanceof Class ? (Class<?>)childType : TypeUtils.toRawClass(childType);
        return this.typeAdapter.adaptType(jsonChild.getAsObject(), childClass);
    }

    final Object visitChild(Type childType, JsonElement jsonChild) {
        if (jsonChild == null) {
            return null;
        }
        if (jsonChild instanceof JsonArray) {
            return this.visitChildAsArray(childType, jsonChild.getAsJsonArray());
        }
        if (jsonChild instanceof JsonObject) {
            return this.visitChildAsObject(childType, jsonChild);
        }
        if (jsonChild instanceof JsonPrimitive) {
            return this.visitChildAsPrimitive(childType, jsonChild.getAsJsonPrimitive());
        }
        throw new IllegalStateException();
    }

    private Object visitChild(Type type, JsonDeserializationVisitor<?> childVisitor) {
        Object child = childVisitor.getTarget();
        ObjectNavigator on = this.factory.create(child, type);
        on.accept(childVisitor);
        return childVisitor.getTarget();
    }
}

