/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.AbstractMultiViewsHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.elements.interfaces.IMultiViewsModel;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

final class MultiViewsElementProvider
implements IMultiViewsModel {
    private AbstractMultiViewsHandle element;

    MultiViewsElementProvider(AbstractMultiViewsHandle element) {
        this.element = element;
    }

    protected List getViews() {
        List list = this.element.getListProperty("views");
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList retList = new ArrayList();
        retList.addAll(list);
        return Collections.unmodifiableList(retList);
    }

    public DesignElementHandle getCurrentView() {
        int currentViewIndex = this.element.getCurrentViewIndex();
        if (currentViewIndex == -1) {
            return null;
        }
        List views = this.getViews();
        if (views.isEmpty() || views.size() <= currentViewIndex) {
            return null;
        }
        return (DesignElementHandle)views.get(currentViewIndex);
    }

    protected void setCurrentViewIndex(int index) throws SemanticException {
        if (index > -1) {
            List views = this.getViews();
            if (views.isEmpty() || views.size() <= index) {
                return;
            }
        } else if (index < -1) {
            index = -1;
        }
        this.element.setProperty("index", new Integer(index));
    }

    public void addView(DesignElementHandle viewElement) throws SemanticException {
        if (viewElement == null) {
            return;
        }
        this.element.add("views", viewElement);
    }

    public void dropView(DesignElementHandle viewElement) throws SemanticException {
        if (viewElement == null) {
            return;
        }
        CommandStack cmdStack = this.element.getModuleHandle().getCommandStack();
        cmdStack.startTrans(CommandLabelFactory.getCommandLabel("Message.DropElement"));
        try {
            DesignElementHandle currentView = this.getCurrentView();
            if (currentView == viewElement) {
                this.setCurrentViewIndex(-1);
            }
            this.element.drop("views", viewElement);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }
}

