/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.LocalizableInfo;
import org.eclipse.birt.report.model.metadata.MemberInfo;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MethodInfo;

public class ClassInfo
extends LocalizableInfo
implements IClassInfo {
    private IMethodInfo constructor;
    private LinkedHashMap methods;
    private LinkedHashMap members;
    private boolean isNative = false;

    public void addMethod(IMethodInfo methodInfo) throws MetaDataException {
        if (this.methods == null) {
            this.methods = new LinkedHashMap();
        }
        if (StringUtil.isBlank(methodInfo.getName())) {
            throw new MetaDataException(new String[]{methodInfo.getName()}, "MISSING_METHOD_NAME");
        }
        this.methods.put(methodInfo.getName(), methodInfo);
    }

    public void addMemberDefn(IMemberInfo memberDefn) throws MetaDataException {
        if (this.members == null) {
            this.members = new LinkedHashMap();
        }
        if (StringUtil.isBlank(memberDefn.getName())) {
            throw new MetaDataException(new String[]{memberDefn.getName()}, "MISSING_MEMBER_NAME");
        }
        if (this.findMember(memberDefn.getName()) != null) {
            throw new MetaDataException(new String[]{memberDefn.getName(), this.name}, "DUPLICATE_MEMBER_NAME");
        }
        this.members.put(memberDefn.getName(), memberDefn);
    }

    public List getMethods() {
        if (this.methods != null) {
            return new ArrayList(this.methods.values());
        }
        return Collections.EMPTY_LIST;
    }

    public IMethodInfo getMethod(String name) {
        return (IMethodInfo)this.findInfo(this.methods, name);
    }

    public List getMembers() {
        if (this.members != null) {
            return new ArrayList(this.members.values());
        }
        return new ArrayList();
    }

    public IMemberInfo getMember(String name) {
        return this.findMember(name);
    }

    private IMemberInfo findMember(String name) {
        return (MemberInfo)this.findInfo(this.members, name);
    }

    public IMethodInfo getConstructor() {
        return this.constructor;
    }

    MethodInfo findMethod(String name) {
        return (MethodInfo)this.findInfo(this.methods, name);
    }

    private Object findInfo(LinkedHashMap objs, String name) {
        if (objs == null || name == null) {
            return null;
        }
        return objs.get(name);
    }

    public void setConstructor(IMethodInfo constructor) throws MetaDataException {
        assert (constructor != null);
        if (StringUtil.isBlank(constructor.getName())) {
            throw new MetaDataException(new String[]{constructor.getName()}, "MISSING_METHOD_NAME");
        }
        this.constructor = constructor;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void setNative(boolean isNative) {
        this.isNative = isNative;
    }
}

