/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class ListPropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(ListPropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.list";

    public ListPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public int getTypeCode() {
        return 20;
    }

    public String getName() {
        return "list";
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        PropertyType type = MetaDataDictionary.getInstance().getPropertyType(defn.getSubTypeCode());
        assert (type != null);
        if (value instanceof List) {
            List items = (List)value;
            ArrayList<Object> validatedItems = new ArrayList<Object>();
            int i = 0;
            while (i < items.size()) {
                Object item = items.get(i);
                validatedItems.add(type.validateValue(module, defn, item));
                ++i;
            }
            return validatedItems;
        }
        ArrayList<Object> listValue = new ArrayList<Object>();
        Object validatedValue = type.validateValue(module, defn, value);
        listValue.add(validatedValue);
        return listValue;
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        assert (value instanceof List);
        List valueList = (List)value;
        if (valueList.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        PropertyType type = defn.getSubType();
        assert (type != null);
        int i = 0;
        while (i < valueList.size()) {
            Object item = valueList.get(i);
            String stringValue = type.toString(module, defn, item);
            if (sb.length() > 0) {
                sb.append("; ");
            }
            if (stringValue != null) {
                sb.append(stringValue);
            }
            ++i;
        }
        return sb.toString();
    }

    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        return ((ArrayList)value).size();
    }
}

