/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.reflections.ReflectionsException;
import org.reflections.util.ClasspathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtils {
    public static final List<String> primitiveNames = Lists.newArrayList((Object[])new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "void"});
    public static final List<Class> primitiveTypes = Lists.newArrayList((Object[])new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE});
    public static final List<String> primitiveDescriptors = Lists.newArrayList((Object[])new String[]{"Z", "C", "B", "S", "I", "J", "F", "D", "V"});

    public static <T> Collection<? extends Class<?>> getAllSuperTypes(Class<T> type) {
        Collection result = Lists.newArrayList();
        Class<T> superclass = type.getSuperclass();
        Class<?>[] interfaces = type.getInterfaces();
        Collections.addAll(result, interfaces);
        result.add(superclass);
        result = Collections2.filter((Collection)result, (Predicate)Predicates.notNull());
        ArrayList subResult = Lists.newArrayList();
        for (Class aClass1 : result) {
            Collection<Class<?>> classes = ReflectionUtils.getAllSuperTypes(aClass1);
            subResult.addAll(classes);
        }
        result.addAll(subResult);
        return result;
    }

    public static List<AnnotatedElement> getAllSuperTypesAnnotatedWith(AnnotatedElement annotatedElement, Annotation annotation) {
        ArrayList annotated = Lists.newArrayList();
        if (annotatedElement != null) {
            if (annotatedElement.isAnnotationPresent(annotation.annotationType())) {
                annotated.add(annotatedElement);
            }
            if (annotatedElement instanceof Class) {
                ArrayList subResult = Lists.newArrayList();
                Class aClass = (Class)annotatedElement;
                subResult.addAll(ReflectionUtils.getAllSuperTypesAnnotatedWith(aClass.getSuperclass(), annotation));
                for (Class<?> anInterface : aClass.getInterfaces()) {
                    subResult.addAll(ReflectionUtils.getAllSuperTypesAnnotatedWith(anInterface, annotation));
                }
                annotated.addAll(subResult);
            }
        }
        return annotated;
    }

    public static boolean areAnnotationMembersMatching(Annotation annotation1, Annotation annotation2) {
        if (annotation2 != null && annotation1.annotationType() == annotation2.annotationType()) {
            for (Method method : annotation1.annotationType().getDeclaredMethods()) {
                try {
                    if (method.invoke((Object)annotation1, new Object[0]).equals(method.invoke((Object)annotation2, new Object[0]))) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new ReflectionsException(String.format("could not invoke method %s on annotation %s", method.getName(), annotation1.annotationType()), e);
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean areAnnotationMembersMatching(Annotation annotation1, AnnotatedElement annotatedElement) {
        List<AnnotatedElement> elementList = ReflectionUtils.getAllSuperTypesAnnotatedWith(annotatedElement, annotation1);
        if (!elementList.isEmpty()) {
            AnnotatedElement element = elementList.get(0);
            Annotation annotation2 = element.getAnnotation(annotation1.annotationType());
            return ReflectionUtils.areAnnotationMembersMatching(annotation1, annotation2);
        }
        return false;
    }

    protected static <T extends AnnotatedElement> Set<T> getMatchingAnnotations(Set<T> annotatedElements, Annotation annotation) {
        HashSet result = Sets.newHashSet();
        for (AnnotatedElement annotatedElement : annotatedElements) {
            if (!ReflectionUtils.areAnnotationMembersMatching(annotation, annotatedElement)) continue;
            result.add(annotatedElement);
        }
        return result;
    }

    public static Class<?> forName(String typeName, ClassLoader ... classLoaders) {
        String type;
        if (primitiveNames.contains(typeName)) {
            return primitiveTypes.get(primitiveNames.indexOf(typeName));
        }
        if (typeName.contains("[")) {
            int i = typeName.indexOf("[");
            type = typeName.substring(0, i);
            String array = typeName.substring(i).replace("]", "");
            type = primitiveNames.contains(type) ? primitiveDescriptors.get(primitiveNames.indexOf(type)) : "L" + type + ";";
            type = array + type;
        } else {
            type = typeName;
        }
        for (ClassLoader classLoader : ClasspathHelper.classLoaders(classLoaders)) {
            try {
                return Class.forName(type, false, classLoader);
            }
            catch (ClassNotFoundException e) {
            }
        }
        return null;
    }

    public static <T> Class<? extends T>[] forNames(Iterable<String> classes, ClassLoader ... classLoaders) {
        ArrayList result = new ArrayList();
        for (String className : classes) {
            result.add(ReflectionUtils.forName(className, classLoaders));
        }
        return result.toArray(new Class[result.size()]);
    }
}

