/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.serializers.Serializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections
extends ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(Reflections.class);
    protected final transient Configuration configuration;
    private Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store(configuration);
        for (Scanner scanner : configuration.getScanners()) {
            scanner.setConfiguration(configuration);
            scanner.setStore(this.store.get(scanner));
        }
        this.scan();
    }

    public Reflections(final String prefix, final Scanner ... scanners) {
        this(new ConfigurationBuilder(){
            {
                FilterBuilder.Include filter = new FilterBuilder.Include(FilterBuilder.prefix(prefix));
                this.setUrls((Collection<URL>)ClasspathHelper.forPackage(prefix, new ClassLoader[0]));
                this.filterInputsBy(filter);
                if (scanners != null && scanners.length != 0) {
                    for (Scanner scanner : scanners) {
                        scanner.filterResultsBy((Predicate<String>)Predicates.and((Predicate)filter, scanner.getResultFilter()));
                    }
                    this.setScanners(scanners);
                } else {
                    this.setScanners(new TypeAnnotationsScanner().filterResultsBy(filter), new SubTypesScanner().filterResultsBy(filter));
                }
            }
        });
    }

    public Reflections(final Object[] urlHints, final Scanner ... scanners) {
        this(new ConfigurationBuilder(){
            {
                ArrayList prefixes = Lists.newArrayList();
                for (Object urlHint : urlHints) {
                    if (urlHint instanceof String) {
                        this.addUrls((Collection<URL>)ClasspathHelper.forPackage((String)urlHint, new ClassLoader[0]));
                        prefixes.add((String)urlHint);
                        continue;
                    }
                    if (!(urlHint instanceof Class)) continue;
                    this.addUrls(ClasspathHelper.forClass((Class)urlHint, new ClassLoader[0]));
                    prefixes.add(((Class)urlHint).getPackage().getName());
                }
                FilterBuilder filter = new FilterBuilder();
                for (String prefix : prefixes) {
                    filter.include(FilterBuilder.prefix(prefix));
                }
                this.filterInputsBy(filter);
                if (scanners != null && scanners.length != 0) {
                    for (Scanner scanner : scanners) {
                        scanner.filterResultsBy((Predicate<String>)Predicates.and((Predicate)filter, scanner.getResultFilter()));
                    }
                    this.setScanners(scanners);
                } else {
                    this.setScanners(new TypeAnnotationsScanner().filterResultsBy(filter), new SubTypesScanner().filterResultsBy(filter));
                }
            }
        });
    }

    protected Reflections() {
        this.configuration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scan() {
        block17: {
            block18: {
                if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
                    Reflections.log.error("given scan urls are empty. set urls in the configuration");
                    return;
                }
                if (Reflections.log.isDebugEnabled()) {
                    urls = new StringBuilder();
                    for (URL url : this.configuration.getUrls()) {
                        urls.append("\t").append(url.toExternalForm()).append("\n");
                    }
                    Reflections.log.debug("going to scan these urls:\n" + urls);
                }
                time = System.currentTimeMillis();
                executorService = this.configuration.getExecutorService();
                if (executorService != null) break block18;
                i$ = this.configuration.getUrls().iterator();
                ** GOTO lbl21
            }
            futures = Lists.newArrayList();
            try {
                block19: {
                    i$ = this.configuration.getUrls().iterator();
                    break block19;
lbl21:
                    // 3 sources

                    while (i$.hasNext()) {
                        url = i$.next();
                        try {
                            for (Vfs.File file : Vfs.fromURL(url).getFiles()) {
                                this.scan(file);
                            }
                        }
                        catch (ReflectionsException e) {
                            Reflections.log.error("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)e);
                        }
                    }
                    break block17;
                }
                while (i$.hasNext()) {
                    url = i$.next();
                    try {
                        for (final Vfs.File file : Vfs.fromURL(url).getFiles()) {
                            futures.add(executorService.submit(new Runnable(){

                                public void run() {
                                    Reflections.this.scan(file);
                                }
                            }));
                        }
                    }
                    catch (ReflectionsException e) {
                        Reflections.log.error("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)e);
                    }
                }
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                executorService.shutdown();
            }
        }
        time = System.currentTimeMillis() - time;
        keys = this.store.getKeysCount();
        values = this.store.getValuesCount();
        Reflections.log.info(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values %s", new Object[]{time, this.configuration.getUrls().size(), keys, values, executorService != null && executorService instanceof ThreadPoolExecutor != false ? String.format("[using %d cores]", new Object[]{((ThreadPoolExecutor)executorService).getMaximumPoolSize()}) : ""}));
    }

    private void scan(Vfs.File file) {
        String input = file.getRelativePath().replace('/', '.');
        if (this.configuration.acceptsInput(input)) {
            for (Scanner scanner : this.configuration.getScanners()) {
                try {
                    if (!scanner.acceptsInput(input)) continue;
                    scanner.scan(file);
                }
                catch (Exception e) {
                    log.warn("could not scan file " + file.getFullPath() + " with scanner " + scanner.getName(), (Throwable)e);
                }
            }
        }
    }

    public static Reflections collect() {
        return new Reflections(new ConfigurationBuilder()).collect("META-INF/reflections", new FilterBuilder().include(".*-reflections.xml"));
    }

    public Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter) {
        return this.collect(packagePrefix, resourceNameFilter, this.configuration.getSerializer());
    }

    public Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter, Serializer serializer) {
        for (Vfs.File file : Vfs.findFiles(ClasspathHelper.forPackage(packagePrefix, new ClassLoader[0]), packagePrefix, resourceNameFilter)) {
            InputStream inputStream = null;
            try {
                inputStream = file.openInputStream();
                this.merge(serializer.read(inputStream));
                log.info("Reflections collected metadata from " + file + " using serializer " + serializer.getClass().getName());
            }
            catch (IOException e) {
                throw new ReflectionsException("could not merge " + file, e);
            }
            finally {
                Utils.close(inputStream);
            }
        }
        return this;
    }

    public Reflections collect(InputStream inputStream) {
        try {
            this.merge(this.configuration.getSerializer().read(inputStream));
            log.info("Reflections collected metadata from input stream using serializer " + this.configuration.getSerializer().getClass().getName());
        }
        catch (Exception ex) {
            throw new ReflectionsException("could not merge input stream", ex);
        }
        return this;
    }

    public Reflections collect(File file) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            Reflections reflections = this.collect(inputStream);
            return reflections;
        }
        catch (FileNotFoundException e) {
            throw new ReflectionsException("could not obtain input stream from file " + file, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Reflections merge(Reflections reflections) {
        this.store.merge(reflections.store);
        return this;
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Set<String> subTypes = this.store.getSubTypesOf(type.getName());
        return ImmutableSet.copyOf((Object[])ReflectionUtils.forNames(subTypes, new ClassLoader[0]));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<String> typesAnnotatedWith = this.store.getTypesAnnotatedWith(annotation.getName());
        return ImmutableSet.copyOf((Object[])Reflections.forNames(typesAnnotatedWith, new ClassLoader[0]));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        Set<String> typesAnnotatedWith = this.store.getTypesAnnotatedWith(annotation.getName(), honorInherited);
        return ImmutableSet.copyOf((Object[])Reflections.forNames(typesAnnotatedWith, new ClassLoader[0]));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.getTypesAnnotatedWith(annotation, true);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        return Reflections.getMatchingAnnotations(this.getTypesAnnotatedWith(annotation.annotationType(), honorInherited), annotation);
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<String> annotatedWith = this.store.getMethodsAnnotatedWith(annotation.getName());
        HashSet result = Sets.newHashSet();
        for (String annotated : annotatedWith) {
            result.add(Utils.getMethodFromDescriptor(annotated));
        }
        return result;
    }

    public Set<Method> getMethodsAnnotatedWith(Annotation annotation) {
        return Reflections.getMatchingAnnotations(this.getMethodsAnnotatedWith(annotation.annotationType()), annotation);
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        HashSet result = Sets.newHashSet();
        Set<String> annotatedWith = this.store.getFieldsAnnotatedWith(annotation.getName());
        for (String annotated : annotatedWith) {
            result.add(Utils.getFieldFromString(annotated));
        }
        return result;
    }

    public Set<Field> getFieldsAnnotatedWith(Annotation annotation) {
        return Reflections.getMatchingAnnotations(this.getFieldsAnnotatedWith(annotation.annotationType()), annotation);
    }

    public Set<Method> getConverters(Class<?> from, Class<?> to) {
        HashSet result = Sets.newHashSet();
        Set<String> converters = this.store.getConverters(from.getName(), to.getName());
        for (String converter : converters) {
            result.add(Utils.getMethodFromDescriptor(converter));
        }
        return result;
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        return this.store.getResources(namePredicate);
    }

    public Set<String> getResources(final Pattern pattern) {
        return this.getResources(new Predicate<String>(){

            public boolean apply(String input) {
                return pattern.matcher(input).matches();
            }
        });
    }

    public Store getStore() {
        return this.store;
    }

    public File save(String filename) {
        return this.save(filename, this.configuration.getSerializer());
    }

    public File save(String filename, Serializer serializer) {
        File file = serializer.save(this, filename);
        log.info("Reflections successfully saved in " + file + " using " + serializer.getClass().getSimpleName());
        return file;
    }
}

