/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Inherited;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.scanners.ConvertersScanner;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store {
    private final Map<String, Multimap<String, String>> storeMap;

    public Store(Configuration configuration) {
        this(configuration.getExecutorService() != null);
    }

    protected Store(boolean parallelExecutor) {
        this.storeMap = parallelExecutor ? new MapMaker().makeComputingMap((Function)new Function<String, Multimap<String, String>>(){

            public Multimap<String, String> apply(String indexName) {
                return Multimaps.synchronizedSetMultimap((SetMultimap)Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<String>>(){

                    public Set<String> get() {
                        return Sets.newHashSet();
                    }
                }));
            }
        }) : new MapMaker().makeComputingMap((Function)new Function<String, Multimap<String, String>>(){

            public Multimap<String, String> apply(String indexName) {
                return Multimaps.newSetMultimap(new HashMap(), (Supplier)new Supplier<Set<String>>(){

                    public Set<String> get() {
                        return Sets.newHashSet();
                    }
                });
            }
        });
    }

    protected Store() {
        this(false);
    }

    public Set<String> get(Class<? extends Scanner> scannerClass, String ... keys) {
        HashSet result = Sets.newHashSet();
        Multimap<String, String> map = this.get(scannerClass);
        for (String key : keys) {
            result.addAll(map.get((Object)key));
        }
        return result;
    }

    public Multimap<String, String> get(Scanner scanner) {
        return this.get(scanner.getClass());
    }

    public Multimap<String, String> get(Class<? extends Scanner> scannerClass) {
        return this.get(scannerClass.getName());
    }

    public Multimap<String, String> get(String scannerName) {
        return this.storeMap.get(scannerName);
    }

    public Map<String, Multimap<String, String>> getStoreMap() {
        return this.storeMap;
    }

    void merge(Store outer) {
        for (String indexName : outer.storeMap.keySet()) {
            this.storeMap.get(indexName).putAll(outer.get(indexName));
        }
    }

    public Integer getKeysCount() {
        Integer keys = 0;
        for (Multimap<String, String> multimap : this.storeMap.values()) {
            keys = keys + multimap.keySet().size();
        }
        return keys;
    }

    public Integer getValuesCount() {
        Integer values = 0;
        for (Multimap<String, String> multimap : this.storeMap.values()) {
            values = values + multimap.size();
        }
        return values;
    }

    public Set<String> getSubTypesOf(String type) {
        HashSet<String> result = new HashSet<String>();
        Set<String> subTypes = this.get(SubTypesScanner.class, type);
        result.addAll(subTypes);
        for (String subType : subTypes) {
            result.addAll(this.getSubTypesOf(subType));
        }
        return result;
    }

    public Set<String> getTypesAnnotatedWith(String annotation) {
        return this.getTypesAnnotatedWith(annotation, true);
    }

    public Set<String> getTypesAnnotatedWith(String annotation, boolean honorInherited) {
        HashSet<String> result;
        block3: {
            Set<String> types;
            block4: {
                result = new HashSet<String>();
                if (!this.isAnnotation(annotation)) break block3;
                types = this.get(TypeAnnotationsScanner.class, annotation);
                result.addAll(types);
                if (!honorInherited || !this.isInheritedAnnotation(annotation)) break block4;
                for (String type : types) {
                    if (!this.isClass(type)) continue;
                    result.addAll(this.getSubTypesOf(type));
                }
                break block3;
            }
            if (honorInherited) break block3;
            for (String type : types) {
                if (this.isAnnotation(type)) {
                    result.addAll(this.getTypesAnnotatedWith(annotation, false));
                    continue;
                }
                if (!this.hasSubTypes(type)) continue;
                result.addAll(this.getSubTypesOf(type));
            }
        }
        return result;
    }

    public Set<String> getMethodsAnnotatedWith(String annotation) {
        return this.get(MethodAnnotationsScanner.class, annotation);
    }

    public Set<String> getFieldsAnnotatedWith(String annotation) {
        return this.get(FieldAnnotationsScanner.class, annotation);
    }

    public Set<String> getConverters(String from, String to) {
        return this.get(ConvertersScanner.class, ConvertersScanner.getConverterKey(from, to));
    }

    public Set<String> getResources(String key) {
        return this.get(ResourcesScanner.class, key);
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        Set keys = this.get(ResourcesScanner.class).keySet();
        Collection matches = Collections2.filter((Collection)keys, namePredicate);
        return this.get(ResourcesScanner.class, matches.toArray(new String[matches.size()]));
    }

    public Set<String> getResources(final Pattern pattern) {
        return this.getResources(new Predicate<String>(){

            public boolean apply(String input) {
                return pattern.matcher(input).matches();
            }
        });
    }

    public boolean isClass(String type) {
        return !this.isInterface(type);
    }

    public boolean isInterface(String aClass) {
        return ReflectionUtils.forName(aClass, new ClassLoader[0]).isInterface();
    }

    public boolean isAnnotation(String typeAnnotatedWith) {
        return this.getTypeAnnotations().contains(typeAnnotatedWith);
    }

    public boolean isInheritedAnnotation(String typeAnnotatedWith) {
        return this.get(TypeAnnotationsScanner.class).get((Object)Inherited.class.getName()).contains(typeAnnotatedWith);
    }

    public boolean hasSubTypes(String typeAnnotatedWith) {
        return this.getSuperTypes().contains((Object)typeAnnotatedWith);
    }

    public Multiset<String> getSuperTypes() {
        return this.get(SubTypesScanner.class).keys();
    }

    public Set<String> getTypeAnnotations() {
        return this.get(TypeAnnotationsScanner.class).keySet();
    }
}

