/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import org.reflections.Configuration;
import org.reflections.ReflectionsException;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScanner
implements Scanner {
    private Configuration configuration;
    private Multimap<String, String> store;
    private Predicate<String> resultFilter = Predicates.alwaysTrue();

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean acceptsInput(String file) {
        return file.endsWith(".class");
    }

    @Override
    public void scan(Vfs.File file) {
        InputStream inputStream = null;
        try {
            inputStream = file.openInputStream();
            Object cls = this.configuration.getMetadataAdapter().createClassObject(inputStream);
            this.scan(cls);
        }
        catch (IOException e) {
            throw new ReflectionsException("could not create class file from " + file.getName(), e);
        }
        finally {
            Utils.close(inputStream);
        }
    }

    public abstract void scan(Object var1);

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Multimap<String, String> getStore() {
        return this.store;
    }

    @Override
    public void setStore(Multimap<String, String> store) {
        this.store = store;
    }

    @Override
    public Predicate<String> getResultFilter() {
        return this.resultFilter;
    }

    public void setResultFilter(Predicate<String> resultFilter) {
        this.resultFilter = resultFilter;
    }

    @Override
    public Scanner filterResultsBy(Predicate<String> filter) {
        this.setResultFilter(filter);
        return this;
    }

    protected boolean acceptResult(String fqn) {
        return fqn != null && this.getResultFilter().apply((Object)fqn);
    }

    protected MetadataAdapter getMetadataAdapter() {
        return this.configuration.getMetadataAdapter();
    }
}

