/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.compound.AllocTable;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryV2;
import org.eclipse.birt.core.archive.compound.ArchiveHeader;
import org.eclipse.birt.core.archive.compound.Block;
import org.eclipse.birt.core.archive.compound.BlockManager;
import org.eclipse.birt.core.archive.compound.BlockManagerEventAdapter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.archive.compound.NameEntry;
import org.eclipse.birt.core.archive.compound.NameTable;

class ArchiveFileV2
implements IArchiveFile,
ArchiveConstants {
    protected RandomAccessFile rf;
    protected boolean isClosed;
    protected boolean isWritable;
    protected boolean isTransient;
    protected boolean isAppend;
    protected String archiveName;
    protected String systemId;
    protected String dependId;
    protected int BLOCK_SIZE;
    protected ArchiveHeader head;
    protected AllocTable allocTbl;
    protected NameTable entryTbl;
    protected HashMap entries;
    protected BlockManager caches;
    protected int totalBlocks;
    protected int totalDiskBlocks;
    private boolean enableCache = true;
    private boolean useNativeLock = false;

    private void setupArchiveMode(String mode) {
        if ("r".equals(mode)) {
            this.isWritable = false;
            this.isTransient = false;
            this.isAppend = false;
        } else if ("rw".equals(mode)) {
            this.isWritable = true;
            this.isTransient = false;
            this.isAppend = false;
        } else if ("rw+".equals(mode)) {
            this.isWritable = true;
            this.isTransient = false;
            this.isAppend = true;
        } else if ("rwt".equals(mode)) {
            this.isWritable = true;
            this.isTransient = true;
            this.isAppend = false;
        } else {
            throw new IllegalArgumentException();
        }
    }

    ArchiveFileV2(String fileName, RandomAccessFile rf, String mode) throws IOException {
        this(null, null, fileName, rf, mode);
    }

    ArchiveFileV2(String fileName, String mode) throws IOException {
        this(null, null, fileName, null, mode);
    }

    ArchiveFileV2(String systemId, String fileName, String mode) throws IOException {
        this(systemId, null, fileName, null, mode);
    }

    ArchiveFileV2(String systemId, String dependId, String fileName, String mode) throws IOException {
        this(systemId, dependId, fileName, null, mode);
    }

    ArchiveFileV2(String systemId, String dependId, String fileName, RandomAccessFile rf, String mode) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            throw new IOException("The file name is null or empty string.");
        }
        File fd = new File(fileName);
        this.archiveName = fileName = fd.getCanonicalPath();
        this.rf = rf;
        this.systemId = systemId;
        this.dependId = dependId;
        this.setupArchiveMode(mode);
        if (this.isWritable && !this.isAppend) {
            this.createDocument();
        } else if (this.isWritable && this.isAppend) {
            if (!new File(fileName).exists()) {
                this.createDocument();
            } else {
                this.openDocument();
            }
        } else {
            this.openDocument();
        }
        this.isClosed = false;
    }

    public void setCacheSize(int cacheSize) {
        if (cacheSize <= 0) {
            this.enableCache = false;
            this.caches = null;
        } else {
            this.enableCache = true;
            if (this.caches == null) {
                this.caches = new BlockManager(new CacheEventAdapter(), this.BLOCK_SIZE);
            }
            this.caches.setCacheSize(cacheSize);
        }
    }

    public int getUsedCache() {
        if (this.caches != null) {
            return this.caches.getUsedCache();
        }
        return 0;
    }

    public String getDependId() {
        return this.dependId;
    }

    public String getSystemId() {
        if (this.systemId == null) {
            return this.archiveName;
        }
        return this.systemId;
    }

    private void openDocument() throws IOException {
        try {
            if (this.rf == null) {
                if (!this.isWritable && !this.useNativeLock) {
                    this.rf = new RandomAccessFile(this.archiveName, "r");
                } else {
                    this.ensureParentFolderCreated();
                    this.rf = new RandomAccessFile(this.archiveName, "rw");
                }
            }
            this.head = ArchiveHeader.read(this.rf);
            if (this.systemId == null) {
                this.systemId = this.head.systemId;
            }
            if (this.dependId == null) {
                this.dependId = this.head.dependId;
            }
            this.BLOCK_SIZE = this.head.blockSize;
            if (this.enableCache) {
                this.caches = new BlockManager(new CacheEventAdapter(), this.BLOCK_SIZE);
            }
            this.totalDiskBlocks = this.totalBlocks = (int)((this.rf.length() + (long)this.BLOCK_SIZE - 1L) / (long)this.BLOCK_SIZE);
            this.allocTbl = AllocTable.loadTable(this);
            this.entryTbl = NameTable.loadTable(this);
            this.entries = new HashMap();
            for (NameEntry nameEnt : this.entryTbl.listEntries()) {
                this.entries.put(nameEnt.getName(), new ArchiveEntryV2(this, nameEnt));
            }
        }
        catch (IOException ex) {
            if (this.rf != null) {
                this.rf.close();
                this.rf = null;
            }
            throw ex;
        }
    }

    private void createDocument() throws IOException {
        try {
            if (!this.isTransient) {
                this.ensureFileCreated();
                this.rf.setLength(0L);
            }
            this.BLOCK_SIZE = this.getDefaultBlockSize();
            if (this.enableCache) {
                this.caches = new BlockManager(new CacheEventAdapter(), this.BLOCK_SIZE);
            }
            this.totalBlocks = 3;
            this.totalDiskBlocks = 0;
            this.head = new ArchiveHeader(this.BLOCK_SIZE);
            this.head.flush(this);
            this.allocTbl = AllocTable.createTable(this);
            this.entryTbl = NameTable.createTable(this);
            this.entries = new HashMap();
        }
        catch (IOException ex) {
            if (this.rf != null) {
                this.rf.close();
                this.rf = null;
            }
            throw ex;
        }
    }

    public String getName() {
        return this.archiveName;
    }

    public synchronized void close() throws IOException {
        if (this.isWritable) {
            this.head.setStatus(-1);
            if (!this.isTransient) {
                this.flush();
            }
        }
        if (this.rf != null) {
            this.rf.close();
            this.rf = null;
        }
        if (this.isTransient) {
            new File(this.archiveName).delete();
        }
        if (this.caches != null) {
            this.caches.reset();
        }
        this.isClosed = true;
    }

    public synchronized void flush() throws IOException {
        this.assertWritable();
        if (!this.isTransient) {
            this.head.flush(this);
            this.entryTbl.flush();
            this.allocTbl.flush();
            if (this.caches != null) {
                this.caches.flush();
            }
        }
    }

    public synchronized void save() throws IOException {
        this.assertWritable();
        if (this.isTransient) {
            this.isTransient = false;
        }
        this.flush();
    }

    public synchronized void refresh() throws IOException {
        this.assertOpen();
        if (!this.isWritable) {
            this.totalDiskBlocks = this.totalBlocks = (int)((this.rf.length() + (long)this.BLOCK_SIZE - 1L) / (long)this.BLOCK_SIZE);
            this.head.refresh(this);
            this.allocTbl.refresh();
            this.entryTbl.refresh();
        }
    }

    public synchronized boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    public synchronized ArchiveEntry getEntry(String name) {
        return (ArchiveEntry)this.entries.get(name);
    }

    public synchronized List listEntries(String namePattern) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.entries.keySet()) {
            if (namePattern != null && !name.startsWith(namePattern)) continue;
            list.add(name);
        }
        return list;
    }

    public synchronized ArchiveEntry createEntry(String name) throws IOException {
        ArchiveEntry entry;
        this.assertWritable();
        if (!name.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            name = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + name;
        }
        if ((entry = (ArchiveEntry)this.entries.get(name)) != null) {
            entry.setLength(0L);
            return entry;
        }
        NameEntry nameEnt = this.entryTbl.createEntry(name);
        entry = new ArchiveEntryV2(this, nameEnt);
        this.entries.put(name, entry);
        return entry;
    }

    public synchronized boolean removeEntry(String name) throws IOException {
        ArchiveEntryV2 entry;
        this.assertWritable();
        if (!name.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            name = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + name;
        }
        if ((entry = (ArchiveEntryV2)this.entries.get(name)) != null) {
            this.entries.remove(name);
            this.entryTbl.removeEntry(entry.entry);
            if (entry.index != null) {
                this.allocTbl.removeEntry(entry.index);
            }
            return true;
        }
        return false;
    }

    public Object lockEntry(ArchiveEntry entry) throws IOException {
        this.assertOpen();
        ArchiveEntryV2 entryV2 = (ArchiveEntryV2)entry;
        if (this.useNativeLock && !this.isTransient) {
            entryV2.ensureSize(1L);
            int blockId = entryV2.index.getBlock(0);
            return this.rf.getChannel().lock(blockId * this.BLOCK_SIZE, 1L, false);
        }
        return entry;
    }

    public void unlockEntry(Object locker) throws IOException {
        this.assertOpen();
        if (locker instanceof FileLock) {
            FileLock flck = (FileLock)locker;
            flck.release();
        }
        if (!(locker instanceof ArchiveEntry)) {
            throw new IOException("Invalide lock type:" + locker);
        }
    }

    int getTotalBlocks() {
        return this.totalBlocks;
    }

    int allocateBlock() throws IOException {
        this.assertWritable();
        return this.totalBlocks++;
    }

    private void assertWritable() throws IOException {
        this.assertOpen();
        if (!this.isWritable) {
            throw new IOException("Archive must be opend for write. System ID: " + this.systemId);
        }
    }

    private void assertOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("The archive is closed. System ID: " + this.systemId);
        }
    }

    synchronized void read(int blockId, int blockOff, byte[] b, int off, int len) throws IOException {
        this.assertOpen();
        if (this.enableCache) {
            Block block = this.caches.getBlock(blockId);
            block.read(blockOff, b, off, len);
        } else {
            long pos = (long)blockId * (long)this.BLOCK_SIZE + (long)blockOff;
            this.rf.seek(pos);
            this.rf.readFully(b, off, len);
        }
    }

    synchronized void write(int blockId, int blockOff, byte[] b, int off, int len) throws IOException {
        this.assertWritable();
        if (this.enableCache) {
            Block block = this.caches.getBlock(blockId);
            block.write(blockOff, b, off, len);
        } else {
            this.ensureFileCreated();
            long pos = (long)blockId * (long)this.BLOCK_SIZE + (long)blockOff;
            this.rf.seek(pos);
            this.rf.write(b, off, len);
        }
    }

    private void ensureFileCreated() throws IOException {
        if (this.rf != null) {
            return;
        }
        this.ensureParentFolderCreated();
        if (this.isWritable) {
            this.rf = new RandomAccessFile(this.archiveName, "rw");
            this.rf.setLength(0L);
        }
    }

    private void ensureParentFolderCreated() {
        File parentFile = new File(this.archiveName).getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
    }

    int getDefaultBlockSize() {
        String value = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("org.eclipse.birt.core.archive.compound.DEFAULT_BLOCK_SIZE");
            }
        });
        if (value != null) {
            try {
                int defaultBlockSize = Integer.parseInt(value);
                defaultBlockSize = (defaultBlockSize + 1023) / 1024 * 1024;
                if (defaultBlockSize > 0) {
                    return defaultBlockSize;
                }
            }
            catch (Exception exception) {}
        }
        return 4096;
    }

    class CacheEventAdapter
    extends BlockManagerEventAdapter {
        CacheEventAdapter() {
        }

        public void flush(Block block) throws IOException {
            if (ArchiveFileV2.this.isWritable) {
                ArchiveFileV2.this.ensureFileCreated();
                block.flush(ArchiveFileV2.this.rf);
                if (block.id >= ArchiveFileV2.this.totalDiskBlocks) {
                    ArchiveFileV2.this.totalDiskBlocks = block.id + 1;
                }
            }
        }

        public void refresh(Block block) throws IOException {
            ArchiveFileV2.this.assertOpen();
            if (block.id < ArchiveFileV2.this.totalDiskBlocks) {
                block.refresh(ArchiveFileV2.this.rf);
            }
        }
    }
}

