/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.DelegatingJsonElementVisitor;
import com.google.gson.Escaper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElementVisitor;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

class JsonEscapingVisitor
extends DelegatingJsonElementVisitor {
    protected JsonEscapingVisitor(JsonElementVisitor delegate) {
        super(delegate);
    }

    public void visitArrayMember(JsonArray parent, JsonPrimitive member, boolean isFirst) {
        super.visitArrayMember(parent, this.escapeJsonPrimitive(member), isFirst);
    }

    public void visitObjectMember(JsonObject parent, String memberName, JsonPrimitive member, boolean isFirst) {
        super.visitObjectMember(parent, memberName, this.escapeJsonPrimitive(member), isFirst);
    }

    public void visitPrimitive(JsonPrimitive primitive) {
        super.visitPrimitive(this.escapeJsonPrimitive(primitive));
    }

    private JsonPrimitive escapeJsonPrimitive(JsonPrimitive member) {
        String memberValue;
        String escapedValue;
        if (member.isString() && !(escapedValue = Escaper.escapeJsonString(memberValue = member.getAsString())).equals(memberValue)) {
            member.setValue(escapedValue);
        }
        return member;
    }
}

