/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client;

import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.common.HeaderLabel;
import org.jboss.bpm.console.client.model.PluginInfo;
import org.jboss.bpm.console.client.model.ServerStatus;

public class ServerStatusView
implements ViewInterface,
LazyPanel,
IsWidget {
    public static final String ID = ServerStatusView.class.getName();
    private Controller controller;
    private final ApplicationContext appContext;
    private boolean initialized;
    VerticalPanel layoutPanel;
    HorizontalPanel pluginPanel;

    public ServerStatusView(ClientFactory clientFactory) {
        this.appContext = clientFactory.getApplicationContext();
        this.controller = clientFactory.getController();
    }

    public Widget asWidget() {
        this.layoutPanel = new VerticalPanel();
        HeaderLabel console = new HeaderLabel("Console Info");
        this.layoutPanel.add((Widget)console);
        VerticalPanel layout1 = new VerticalPanel();
        layout1.add((Widget)new HTML("Version:"));
        layout1.add((Widget)new HTML("2.3.0-SNAPSHOT"));
        this.layoutPanel.add((Widget)layout1);
        HeaderLabel server = new HeaderLabel("Server Info");
        this.layoutPanel.add((Widget)server);
        HorizontalPanel layout2 = new HorizontalPanel();
        VerticalPanel row1 = new VerticalPanel();
        row1.add((Widget)new HTML("Host:"));
        this.pluginPanel = new HorizontalPanel();
        VerticalPanel row2 = new VerticalPanel();
        row2.add((Widget)new Label("Plugins:"));
        row2.add((Widget)this.pluginPanel);
        layout2.add((Widget)row1);
        layout2.add((Widget)row2);
        this.layoutPanel.add((Widget)layout2);
        this.controller.addView(ID, (ViewInterface)this);
        this.update(ServerPlugins.getStatus());
        return this.layoutPanel;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (!this.initialized) {
            this.update(ServerPlugins.getStatus());
            this.initialized = true;
        }
    }

    private void update(ServerStatus status) {
        this.pluginPanel.clear();
        Grid g = new Grid(status.getPlugins().size(), 2);
        g.setWidth("100%");
        for (int row = 0; row < status.getPlugins().size(); ++row) {
            PluginInfo p = (PluginInfo)status.getPlugins().get(row);
            String type = p.getType().substring(p.getType().lastIndexOf(".") + 1, p.getType().length());
            g.setText(row, 0, type);
            Image img = p.isAvailable() ? new Image("images/icons/confirm_small.png") : new Image("images/icons/deny_small.png");
            g.setWidget(row, 1, (Widget)img);
        }
        this.pluginPanel.add((Widget)g);
    }
}

