/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.common;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizableListBox<T>
implements IsWidget {
    private List<T> list = new ArrayList<T>();
    private ListBox listBox = new ListBox();
    private final ItemFormatter<T> formatter;
    private boolean hasFirstLine = false;

    public CustomizableListBox(ItemFormatter<T> formatter) {
        this.formatter = formatter;
    }

    public void addItem(T item) {
        this.list.add(item);
        this.listBox.addItem(this.formatter.format(item));
    }

    public Widget asWidget() {
        return this.listBox;
    }

    public void clear() {
        this.list.clear();
        this.listBox.clear();
    }

    public int getSelectedIndex() {
        if (this.hasFirstLine) {
            return this.listBox.getSelectedIndex() - 1;
        }
        return this.listBox.getSelectedIndex();
    }

    public T getItem(int selectedIndex) {
        return this.list.get(selectedIndex);
    }

    public void setFirstLine(String line) {
        this.listBox.addItem(line);
    }

    public int getItemCount() {
        return this.list.size();
    }

    public void setSelectedIndex(int index) {
        this.listBox.setSelectedIndex(index);
    }

    public void setFocus(boolean b) {
        this.listBox.setFocus(b);
    }

    public HandlerRegistration addChangeHandler(ChangeHandler changeHandler) {
        return this.listBox.addChangeHandler(changeHandler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ItemFormatter<T> {
        public String format(T var1);
    }
}

