/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.common;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.console.client.common.PagingCallback;

public class PagingPanel
extends HorizontalPanel {
    private PagingCallback callback;
    private int limit = 12;
    private int page = 0;
    private boolean leftBounds = true;
    private boolean rightBounds;
    private Button revBtn;
    private Button ffwBtn;

    public PagingPanel(final PagingCallback callback) {
        this.setStyleName("bpm-paging-panel");
        this.callback = callback;
        ClickHandler clickHandler = new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                PagingPanel.this.page--;
                PagingPanel.this.rightBounds = false;
                callback.rev();
            }
        };
        this.revBtn = new Button("<", clickHandler);
        this.add((Widget)this.revBtn);
        ClickHandler clickHandler2 = new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                PagingPanel.this.page++;
                PagingPanel.this.leftBounds = false;
                callback.ffw();
            }
        };
        this.ffwBtn = new Button(">", clickHandler2);
        this.add((Widget)this.ffwBtn);
    }

    public void reset() {
        this.leftBounds = true;
        this.rightBounds = false;
        this.page = 0;
    }

    public List trim(List tmp) {
        List trimmed = new ArrayList();
        int size = tmp.size();
        if (this.limit >= size) {
            trimmed = tmp;
            this.rightBounds = true;
        } else {
            if (this.page <= 0) {
                this.page = 0;
                this.leftBounds = true;
            }
            int begin = 0;
            int end = 0;
            if (this.page * this.limit >= size) {
                begin = (this.page - 1) * this.limit;
                this.rightBounds = true;
            } else {
                begin = this.page * this.limit;
            }
            if (begin + this.limit >= size) {
                end = size;
                this.rightBounds = true;
            } else {
                end = begin + this.limit;
            }
            int i = 0;
            for (Object o : tmp) {
                if (i >= begin && i < end) {
                    trimmed.add(o);
                }
                ++i;
            }
        }
        this.revBtn.setEnabled(!this.leftBounds);
        this.ffwBtn.setEnabled(!this.rightBounds);
        return trimmed;
    }
}

