/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.engine;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import org.jboss.bpm.console.client.common.PropertyGrid;
import org.jboss.bpm.console.client.engine.ResourcePanel;
import org.jboss.bpm.console.client.engine.ResumeDeploymentAction;
import org.jboss.bpm.console.client.engine.SuspendDeploymentAction;
import org.jboss.bpm.console.client.model.DeploymentRef;

public class DeploymentDetailView
extends HorizontalPanel
implements ViewInterface {
    public static final String ID = DeploymentDetailView.class.getName();
    private Controller controller;
    private PropertyGrid grid = new PropertyGrid(new String[]{"ID:", "Name:", "Processes:"});
    private DeploymentRef currentDeployment;
    private ResourcePanel resourcePanel;
    Button suspendBtn;
    Button resumeBtn;

    public DeploymentDetailView() {
        super.setStyleName("bpm-detail-panel");
        HorizontalPanel propLayout = new HorizontalPanel();
        propLayout.add((Widget)this.grid);
        this.suspendBtn = new Button("Retire", new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                DeploymentRef deploymentRef = DeploymentDetailView.this.getSelection();
                if (deploymentRef != null) {
                    if (Window.confirm((String)"Retire deployment. Do you want to retire this deployment? Any associated process will be suspended.")) {
                        DeploymentDetailView.this.controller.handleEvent(new Event(SuspendDeploymentAction.ID, (Object)DeploymentDetailView.this.getSelection().getId()));
                    }
                } else {
                    Window.alert((String)"Missing selection. Please select a deployment");
                }
            }
        });
        this.resumeBtn = new Button("Activate", new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                DeploymentRef deploymentRef = DeploymentDetailView.this.getSelection();
                if (deploymentRef != null) {
                    if (Window.confirm((String)"Activate deployment. Do you want to resume this deployment?")) {
                        DeploymentDetailView.this.controller.handleEvent(new Event(ResumeDeploymentAction.ID, (Object)DeploymentDetailView.this.getSelection().getId()));
                    }
                } else {
                    Window.alert((String)"Missing selection. Please select a deployment");
                }
            }
        });
        VerticalPanel btnLayout = new VerticalPanel();
        btnLayout.add((Widget)this.suspendBtn);
        btnLayout.add((Widget)this.resumeBtn);
        propLayout.add((Widget)btnLayout);
        VerticalPanel deck = new VerticalPanel();
        deck.add((Widget)propLayout);
        ScrollPanel scrollPanel = new ScrollPanel();
        this.resourcePanel = new ResourcePanel();
        scrollPanel.add((Widget)this.resourcePanel);
        deck.add((Widget)scrollPanel);
        ListBox dropBox = new ListBox(false);
        dropBox.setStyleName("bpm-operation-ui");
        dropBox.addItem("Properties");
        dropBox.addItem("Resources");
        dropBox.addChangeListener(new ChangeListener(){

            public void onChange(Widget sender) {
            }
        });
        this.add((Widget)dropBox);
        this.add((Widget)deck);
        this.add((Widget)deck);
    }

    private DeploymentRef getSelection() {
        return this.currentDeployment;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.resourcePanel.setController(controller);
    }

    public void update(DeploymentRef deployment) {
        this.currentDeployment = deployment;
        String[] values = new String[]{deployment.getId(), deployment.getName(), deployment.getDefinitions().toString()};
        this.resumeBtn.setEnabled(deployment.isSuspended());
        this.suspendBtn.setEnabled(!this.resumeBtn.isEnabled());
        this.grid.update(values);
        this.resourcePanel.update(deployment);
    }

    public void clearView() {
        this.currentDeployment = null;
        this.grid.clear();
        this.resourcePanel.clearView();
        this.suspendBtn.setEnabled(false);
        this.resumeBtn.setEnabled(false);
    }
}

