/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.engine;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.engine.DeleteDeploymentAction;
import org.jboss.bpm.console.client.engine.DeploymentDetailView;
import org.jboss.bpm.console.client.engine.ResumeDeploymentAction;
import org.jboss.bpm.console.client.engine.SuspendDeploymentAction;
import org.jboss.bpm.console.client.engine.UpdateDeploymentDetailAction;
import org.jboss.bpm.console.client.engine.UpdateDeploymentsAction;
import org.jboss.bpm.console.client.model.DeploymentRef;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

public class DeploymentListView
implements ViewInterface,
IsWidget,
DataDriven {
    public static final String ID = DeploymentListView.class.getName();
    private Controller controller;
    private boolean initialized;
    private VerticalPanel deploymentList = null;
    private CustomizableListBox<DeploymentRef> listBox;
    private DeploymentRef selection = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private int FILTER_NONE = 10;
    private int FILTER_ACTIVE = 20;
    private int FILTER_SUSPENDED = 30;
    private int currentFilter = this.FILTER_NONE;
    private List<DeploymentRef> deployments = null;
    private DeploymentDetailView detailView;
    DockPanel panel;
    private boolean isRiftsawInstance = false;
    private final ApplicationContext applicationContext;

    public DeploymentListView(ClientFactory clientFactory) {
        this.applicationContext = clientFactory.getApplicationContext();
        this.controller = clientFactory.getController();
        this.isRiftsawInstance = clientFactory.getApplicationContext().getConfig().getProfileName().equals("BPEL Console");
    }

    public Widget asWidget() {
        this.panel = new DockPanel();
        this.listBox = this.createListBox();
        this.initialize();
        this.panel.add((Widget)this.detailView, DockPanel.SOUTH);
        this.panel.add((Widget)this.deploymentList, DockPanel.CENTER);
        this.controller.addAction(UpdateDeploymentsAction.ID, (ActionInterface)new UpdateDeploymentsAction(this.applicationContext));
        this.controller.addAction(UpdateDeploymentDetailAction.ID, (ActionInterface)new UpdateDeploymentDetailAction());
        this.controller.addAction(DeleteDeploymentAction.ID, (ActionInterface)new DeleteDeploymentAction(this.applicationContext));
        this.controller.addAction(SuspendDeploymentAction.ID, (ActionInterface)new SuspendDeploymentAction(this.applicationContext));
        this.controller.addAction(ResumeDeploymentAction.ID, (ActionInterface)new ResumeDeploymentAction(this.applicationContext));
        this.controller.addView(ID, (ViewInterface)this);
        return this.panel;
    }

    private CustomizableListBox createListBox() {
        final CustomizableListBox<DeploymentRef> listBox = new CustomizableListBox<DeploymentRef>(new CustomizableListBox.ItemFormatter<DeploymentRef>(){

            @Override
            public String format(DeploymentRef deploymentRef) {
                String result = "";
                String color = deploymentRef.isSuspended() ? "#CCCCCC" : "#000000";
                String text = "<div style=\"color:" + color + "\">" + deploymentRef.getName() + "</div>";
                result = result + new HTML(text);
                String status = deploymentRef.isSuspended() ? "retired" : "active";
                String s = "<div style=\"color:" + color + "\">" + status + "</div>";
                result = result + new HTML(status);
                return result;
            }
        });
        listBox.setFirstLine("Deployment, Status");
        listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int index = listBox.getSelectedIndex();
                if (index != -1) {
                    DeploymentRef item = (DeploymentRef)listBox.getItem(index);
                    DeploymentListView.this.controller.handleEvent(new Event(UpdateDeploymentDetailAction.ID, (Object)item));
                }
            }
        });
        return listBox;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (!this.initialized) {
            this.deploymentList = new VerticalPanel();
            HorizontalPanel toolBox = new HorizontalPanel();
            MenuBar toolBar = new MenuBar();
            toolBar.addItem("Refresh", new Command(){

                public void execute() {
                    DeploymentListView.this.reset();
                    DeploymentListView.this.controller.handleEvent(new Event(UpdateDeploymentsAction.ID, null));
                }
            });
            MenuItem deleteBtn = new MenuItem("Delete", new Command(){

                public void execute() {
                    DeploymentRef deploymentRef = DeploymentListView.this.getSelection();
                    if (deploymentRef != null) {
                        if (Window.confirm((String)"Delete deployment. Do you want to delete this deployment? Any related data will be removed.")) {
                            DeploymentListView.this.controller.handleEvent(new Event(DeleteDeploymentAction.ID, (Object)DeploymentListView.this.getSelection().getId()));
                        }
                    } else {
                        Window.alert((String)"Missing selection. Please select a deployment");
                    }
                }
            });
            if (!this.isRiftsawInstance) {
                toolBar.addItem(deleteBtn);
            }
            toolBox.add((Widget)toolBar);
            VerticalPanel filterPanel = new VerticalPanel();
            filterPanel.setStyleName("mosaic-ToolBar");
            final ListBox dropBox = new ListBox(false);
            dropBox.setStyleName("bpm-operation-ui");
            dropBox.addItem("All");
            dropBox.addItem("Active");
            dropBox.addItem("Retired");
            dropBox.addChangeListener(new ChangeListener(){

                public void onChange(Widget sender) {
                    switch (dropBox.getSelectedIndex()) {
                        case 0: {
                            DeploymentListView.this.currentFilter = DeploymentListView.this.FILTER_NONE;
                            break;
                        }
                        case 1: {
                            DeploymentListView.this.currentFilter = DeploymentListView.this.FILTER_ACTIVE;
                            break;
                        }
                        case 2: {
                            DeploymentListView.this.currentFilter = DeploymentListView.this.FILTER_SUSPENDED;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("No such index");
                        }
                    }
                    DeploymentListView.this.renderFiltered();
                }
            });
            filterPanel.add((Widget)dropBox);
            toolBox.add((Widget)filterPanel);
            this.deploymentList.add((Widget)toolBox);
            this.deploymentList.add(this.listBox);
            this.detailView = new DeploymentDetailView();
            this.controller.addView(DeploymentDetailView.ID, (ViewInterface)this.detailView);
            Timer t = new Timer(){

                public void run() {
                    DeploymentListView.this.controller.handleEvent(new Event(UpdateDeploymentsAction.ID, null));
                }
            };
            t.schedule(500);
            this.initialized = true;
        }
    }

    public DeploymentRef getSelection() {
        DeploymentRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    public void reset() {
        this.listBox.clear();
        this.controller.handleEvent(new Event(UpdateDeploymentDetailAction.ID, null));
    }

    public void update(Object ... data) {
        this.deployments = (List)data[0];
        this.renderFiltered();
    }

    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.deploymentList, isLoading);
    }

    private void renderFiltered() {
        if (this.deployments != null) {
            this.reset();
            for (DeploymentRef dpl : this.deployments) {
                boolean showSuspended;
                if (this.FILTER_NONE == this.currentFilter) {
                    this.listBox.addItem(dpl);
                    continue;
                }
                boolean bl = showSuspended = this.FILTER_SUSPENDED == this.currentFilter;
                if (dpl.isSuspended() != showSuspended) continue;
                this.listBox.addItem(dpl);
            }
        }
    }

    public void select(String deploymentId) {
        for (int i = 0; i < this.listBox.getItemCount(); ++i) {
            DeploymentRef ref = this.listBox.getItem(i);
            if (!ref.getId().equals(deploymentId)) continue;
            this.listBox.setSelectedIndex(i);
            break;
        }
    }
}

