/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.engine;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.Date;
import java.util.List;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.engine.ExecuteJobAction;
import org.jboss.bpm.console.client.engine.UpdateJobsAction;
import org.jboss.bpm.console.client.model.JobRef;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobListView
implements ViewInterface,
IsWidget,
DataDriven {
    public static final String ID = JobListView.class.getName();
    private Controller controller;
    private VerticalPanel jobList = null;
    private CustomizableListBox<JobRef> listBox;
    private JobRef selection = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private int FILTER_NONE = 10;
    private int FILTER_TIMER = 20;
    private int FILTER_MESSAGE = 30;
    private int currentFilter = this.FILTER_NONE;
    private List<JobRef> jobs = null;
    SimplePanel panel;
    private boolean initialized;
    private final ClientFactory clientFactory;

    public JobListView(ClientFactory clientFactory) {
        this.controller = clientFactory.getController();
        this.clientFactory = clientFactory;
    }

    public Widget asWidget() {
        this.panel = new SimplePanel();
        this.listBox = this.createListBox();
        this.initialize();
        this.panel.add((Widget)this.jobList);
        this.controller.addView(ID, (ViewInterface)this);
        this.controller.addAction(ExecuteJobAction.ID, (ActionInterface)new ExecuteJobAction(this.clientFactory.getApplicationContext()));
        return this.panel;
    }

    private CustomizableListBox<JobRef> createListBox() {
        CustomizableListBox<JobRef> listBox = new CustomizableListBox<JobRef>(new CustomizableListBox.ItemFormatter<JobRef>(){

            @Override
            public String format(JobRef item) {
                String result = "";
                result = result + item.getId();
                result = result + " ";
                long ts = item.getTimestamp();
                String ds = ts > 0L ? JobListView.this.dateFormat.format(new Date(ts)) : "";
                result = result + ds;
                result = result + " ";
                result = result + item.getType();
                return result;
            }
        });
        listBox.setFirstLine("ID, Due Date, Type");
        return listBox;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (!this.initialized) {
            this.jobList = new VerticalPanel();
            HorizontalPanel toolBox = new HorizontalPanel();
            MenuBar toolBar = new MenuBar();
            toolBar.addItem("Refresh", new Command(){

                public void execute() {
                    JobListView.this.controller.handleEvent(new Event(UpdateJobsAction.ID, null));
                }
            });
            toolBar.addItem("Execute", new Command(){

                public void execute() {
                    JobRef selection = JobListView.this.getSelection();
                    if (null == selection) {
                        Window.alert((String)"Missing selection. Please select a job!");
                    } else {
                        JobListView.this.controller.handleEvent(new Event(ExecuteJobAction.ID, (Object)selection.getId()));
                    }
                }
            });
            toolBox.add((Widget)toolBar);
            VerticalPanel filterPanel = new VerticalPanel();
            filterPanel.setStyleName("mosaic-ToolBar");
            final ListBox dropBox = new ListBox(false);
            dropBox.setStyleName("bpm-operation-ui");
            dropBox.addItem("All");
            dropBox.addItem("Timers");
            dropBox.addItem("Messages");
            dropBox.addChangeListener(new ChangeListener(){

                public void onChange(Widget sender) {
                    switch (dropBox.getSelectedIndex()) {
                        case 0: {
                            JobListView.this.currentFilter = JobListView.this.FILTER_NONE;
                            break;
                        }
                        case 1: {
                            JobListView.this.currentFilter = JobListView.this.FILTER_TIMER;
                            break;
                        }
                        case 2: {
                            JobListView.this.currentFilter = JobListView.this.FILTER_MESSAGE;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("No such index");
                        }
                    }
                    JobListView.this.renderFiltered();
                }
            });
            filterPanel.add((Widget)dropBox);
            toolBox.add((Widget)filterPanel);
            this.jobList.add((Widget)toolBox);
            this.jobList.add(this.listBox);
            Timer t = new Timer(){

                public void run() {
                    JobListView.this.controller.handleEvent(new Event(UpdateJobsAction.ID, null));
                }
            };
            t.schedule(500);
            this.controller.addAction(UpdateJobsAction.ID, (ActionInterface)new UpdateJobsAction(this.clientFactory.getApplicationContext()));
            this.initialized = true;
        }
    }

    @Override
    public void reset() {
        this.listBox.clear();
    }

    @Override
    public void update(Object ... data) {
        this.jobs = (List)data[0];
        this.renderFiltered();
    }

    @Override
    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.jobList, isLoading);
    }

    private void renderFiltered() {
        if (this.jobs != null) {
            this.reset();
            for (JobRef def : this.jobs) {
                if (this.FILTER_NONE == this.currentFilter) {
                    this.listBox.addItem(def);
                    continue;
                }
                if (this.FILTER_TIMER == this.currentFilter && def.getType().equals("timer")) {
                    this.listBox.addItem(def);
                    continue;
                }
                if (this.FILTER_MESSAGE != this.currentFilter || !def.getType().equals("message")) continue;
                this.listBox.addItem(def);
            }
        }
    }

    public JobRef getSelection() {
        JobRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }
}

