/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.history;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.history.LoadProcessInstanceEventsAction;
import org.jboss.bpm.console.client.model.HistoryProcessInstanceRef;
import org.jboss.bpm.console.client.model.StringRef;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHistoryInstanceListView
implements ViewInterface,
IsWidget,
DataDriven {
    public static final String ID = ProcessHistoryInstanceListView.class.getName();
    private Controller controller;
    private VerticalPanel panel;
    private VerticalPanel instanceList;
    private CustomizableListBox<HistoryProcessInstanceRef> listbox;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private WidgetWindowPanel processEventsWindow;
    private CustomizableListBox<String> processEvents;
    private String selectedProcessInstanceId;
    private final ClientFactory clientFactory;

    public ProcessHistoryInstanceListView(ClientFactory clientFactory) {
        this.controller = clientFactory.getController();
        this.clientFactory = clientFactory;
    }

    public Widget asWidget() {
        this.controller.addView(ID, (ViewInterface)this);
        this.controller.addAction(LoadProcessInstanceEventsAction.ID, (ActionInterface)new LoadProcessInstanceEventsAction(this.clientFactory.getApplicationContext()));
        this.panel = new VerticalPanel();
        this.panel.setSpacing(5);
        this.instanceList = new VerticalPanel();
        this.instanceList.setSpacing(5);
        this.listbox = new CustomizableListBox<HistoryProcessInstanceRef>(new CustomizableListBox.ItemFormatter<HistoryProcessInstanceRef>(){

            @Override
            public String format(HistoryProcessInstanceRef historyProcessInstanceRef) {
                String result = "";
                result = result + historyProcessInstanceRef.getProcessInstanceId();
                result = result + "";
                result = result + historyProcessInstanceRef.getKey();
                result = result + historyProcessInstanceRef.getState();
                result = result + ProcessHistoryInstanceListView.this.dateFormat.format(historyProcessInstanceRef.getStartTime());
                result = result + ProcessHistoryInstanceListView.this.dateFormat.format(historyProcessInstanceRef.getEndTime());
                return result;
            }
        });
        this.listbox.setFirstLine("Instance Id, Correlation Key, Status, Start Time, Finish Time");
        this.listbox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int index = ProcessHistoryInstanceListView.this.listbox.getSelectedIndex();
                if (index != -1) {
                    HistoryProcessInstanceRef historyInstance = (HistoryProcessInstanceRef)ProcessHistoryInstanceListView.this.listbox.getItem(index);
                    ProcessHistoryInstanceListView.this.selectedProcessInstanceId = historyInstance.getProcessInstanceId();
                    ProcessHistoryInstanceListView.this.createHistoryInstanceDetailWindow();
                }
            }
        });
        this.instanceList.add(this.listbox);
        this.panel.add((Widget)this.instanceList);
        return this.panel;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void reset() {
    }

    @Override
    public void update(Object ... data) {
        List result = (List)data[0];
        this.listbox.clear();
        for (HistoryProcessInstanceRef ref : result) {
            this.listbox.addItem(ref);
        }
    }

    @Override
    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.instanceList, isLoading);
    }

    public void createHistoryInstanceDetailWindow() {
        ScrollPanel layout = new ScrollPanel();
        layout.setStyleName("bpm-window-layout");
        Label header = new Label("Instance: " + this.selectedProcessInstanceId);
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header);
        TabPanel tabPanel = new TabPanel();
        this.processEvents = new CustomizableListBox<String>(new CustomizableListBox.ItemFormatter<String>(){

            @Override
            public String format(String item) {
                return new HTML(item).getHTML();
            }
        });
        this.processEvents.setFirstLine("Process Events");
        VerticalPanel sourcePanel = new VerticalPanel();
        sourcePanel.add(this.processEvents);
        tabPanel.add((Widget)sourcePanel, "Activity Events");
        tabPanel.selectTab(0);
        layout.add((Widget)tabPanel);
        this.processEventsWindow = new WidgetWindowPanel("History Instance Activity", (Widget)layout, true);
        this.controller.handleEvent(new Event(LoadProcessInstanceEventsAction.ID, (Object)this.selectedProcessInstanceId));
    }

    public void populateInstanceEvents(List<StringRef> refs) {
        this.processEvents.clear();
        for (StringRef value : refs) {
            this.processEvents.addItem(this.formatResult(value.getValue()));
        }
    }

    private String formatResult(String value) {
        StringBuffer sbuffer = new StringBuffer();
        String[] split = value.split("~");
        sbuffer.append(split[0] + " : ");
        for (int i = 1; i < value.length(); ++i) {
            sbuffer.append("<br/>");
            sbuffer.append(split[i]);
        }
        return sbuffer.toString();
    }
}

