/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.history;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.Date;
import java.util.List;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.history.LoadProcessDefinitionsAction;
import org.jboss.bpm.console.client.history.LoadProcessHistoryAction;
import org.jboss.bpm.console.client.history.ProcessSearchEvent;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessHistorySearchView
implements IsWidget,
ViewInterface {
    public static final String ID = ProcessHistorySearchView.class.getName();
    private final VerticalPanel panel = new VerticalPanel();
    private Controller controller;
    private ListBox processStatusList;
    private ListBox definitionList;
    private TextBox correlationKey;
    private DateBox startTime;
    private DateBox endTime;

    public ProcessHistorySearchView(ClientFactory clientFactory) {
        this.controller = clientFactory.getController();
        this.controller.addView(ID, (ViewInterface)this);
        this.controller.addAction(LoadProcessHistoryAction.ID, (ActionInterface)new LoadProcessHistoryAction(clientFactory.getApplicationContext()));
        this.controller.addAction(LoadProcessDefinitionsAction.ID, (ActionInterface)new LoadProcessDefinitionsAction(clientFactory.getApplicationContext()));
    }

    public Widget asWidget() {
        this.controller.handleEvent(new Event(LoadProcessDefinitionsAction.ID, null));
        return this.panel;
    }

    public Widget initialize(final List<ProcessDefinitionRef> processDefinitions) {
        this.panel.setSpacing(5);
        MenuBar toolbar = new MenuBar();
        this.panel.add((Widget)toolbar);
        toolbar.addItem("Search", new Command(){

            public void execute() {
                Date edate;
                if (ProcessHistorySearchView.this.definitionList.getItemCount() < 1) {
                    return;
                }
                String proDef = ProcessHistorySearchView.this.definitionList.getValue(ProcessHistorySearchView.this.definitionList.getSelectedIndex());
                String definitionId = null;
                for (ProcessDefinitionRef ref : processDefinitions) {
                    if (!proDef.equals(ref.getName())) continue;
                    definitionId = ref.getId();
                }
                String theStatus = ProcessHistorySearchView.this.processStatusList.getValue(ProcessHistorySearchView.this.processStatusList.getSelectedIndex());
                Date theDate = ProcessHistorySearchView.this.startTime.getValue();
                if (theDate == null) {
                    theDate = new Date(103, 1, 1);
                }
                if ((edate = ProcessHistorySearchView.this.endTime.getValue()) == null) {
                    edate = new Date();
                }
                String ckey = ProcessHistorySearchView.this.correlationKey.getValue();
                ProcessSearchEvent event = new ProcessSearchEvent();
                event.setDefinitionKey(definitionId);
                event.setStatus(theStatus);
                event.setStartTime(theDate.getTime());
                event.setEndTime(edate.getTime());
                event.setKey(ckey);
                ProcessHistorySearchView.this.controller.handleEvent(new Event(LoadProcessHistoryAction.ID, (Object)event));
            }
        });
        VerticalPanel formPanel = new VerticalPanel();
        this.panel.add((Widget)formPanel);
        VerticalPanel processDefBox = new VerticalPanel();
        processDefBox.add((Widget)new Label("Process Definition: "));
        this.definitionList = new ListBox();
        for (ProcessDefinitionRef ref : processDefinitions) {
            this.definitionList.addItem(ref.getName());
        }
        processDefBox.add((Widget)this.definitionList);
        formPanel.add((Widget)processDefBox);
        formPanel.add((Widget)this.createProcessStatusListBox());
        formPanel.add((Widget)this.createCorrelationKeyTextBox());
        formPanel.add((Widget)this.createStartTimeDateBox());
        formPanel.add((Widget)this.createEndTimeDateBox());
        return this.panel;
    }

    private VerticalPanel createEndTimeDateBox() {
        VerticalPanel box4 = new VerticalPanel();
        this.endTime = new DateBox();
        this.endTime.setWidth("550px");
        box4.add((Widget)new Label("End Time: "));
        box4.add((Widget)this.endTime);
        return box4;
    }

    private VerticalPanel createStartTimeDateBox() {
        VerticalPanel box3 = new VerticalPanel();
        this.startTime = new DateBox();
        this.startTime.setWidth("550px");
        box3.add((Widget)new Label("Start Time: "));
        box3.add((Widget)this.startTime);
        return box3;
    }

    private VerticalPanel createCorrelationKeyTextBox() {
        VerticalPanel box2 = new VerticalPanel();
        this.correlationKey = new TextBox();
        this.correlationKey.setWidth("550px");
        box2.add((Widget)new Label("Correlation Key: "));
        box2.add((Widget)this.correlationKey);
        box2.add((Widget)new Label(" format: correlation name = [correlation value], e.g Session=[1]"));
        return box2;
    }

    private VerticalPanel createProcessStatusListBox() {
        VerticalPanel box1 = new VerticalPanel();
        this.processStatusList = new ListBox();
        this.processStatusList.addItem("COMPLETED");
        this.processStatusList.addItem("FAILED");
        this.processStatusList.addItem("TERMINATED");
        box1.add((Widget)new Label("Process Status: "));
        box1.add((Widget)this.processStatusList);
        return box1;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }
}

