/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.ModelCommands;
import org.jboss.bpm.console.client.common.ModelParts;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.Message;
import org.jboss.errai.bus.client.api.MessageCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionHistoryListView
implements IsWidget,
ViewInterface,
DataDriven {
    public static final String ID = DefinitionHistoryListView.class.getName();
    private VerticalPanel definitionList = null;
    private CustomizableListBox<ProcessDefinitionRef> listBox;
    private boolean isInitialized;
    private List<ProcessDefinitionRef> definitions = null;
    private PagingPanel pagingPanel;
    private SimplePanel panel;

    public Widget asWidget() {
        this.panel = new SimplePanel();
        this.listBox = this.createListBox();
        this.initialize();
        return this.panel;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.definitionList = new VerticalPanel();
            HorizontalPanel toolBox = new HorizontalPanel();
            MenuBar toolBar = new MenuBar();
            toolBar.addItem("Refresh", new Command(){

                public void execute() {
                    DefinitionHistoryListView.this.reload();
                }
            });
            toolBox.add((Widget)toolBar);
            this.definitionList.add((Widget)toolBox);
            this.definitionList.add(this.listBox);
            this.pagingPanel = new PagingPanel(new PagingCallback(){

                public void rev() {
                    DefinitionHistoryListView.this.renderFiltered();
                }

                public void ffw() {
                    DefinitionHistoryListView.this.renderFiltered();
                }
            });
            this.definitionList.add((Widget)this.pagingPanel);
            this.panel.add((Widget)this.definitionList);
            ErraiBus.get().subscribe("appContext.model.listener", new MessageCallback(){

                public void callback(Message message) {
                    switch (ModelCommands.valueOf(message.getCommandType())) {
                        case HAS_BEEN_UPDATED: {
                            if (!((String)message.get(String.class, (Enum)ModelParts.CLASS)).equals("deploymentModel")) break;
                            DefinitionHistoryListView.this.reload();
                        }
                    }
                }
            });
            this.isInitialized = true;
        }
    }

    private void reload() {
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                DefinitionHistoryListView.this.listBox.clear();
            }
        });
    }

    private CustomizableListBox<ProcessDefinitionRef> createListBox() {
        final CustomizableListBox<ProcessDefinitionRef> listBox = new CustomizableListBox<ProcessDefinitionRef>(new CustomizableListBox.ItemFormatter<ProcessDefinitionRef>(){

            @Override
            public String format(ProcessDefinitionRef processDefinitionRef) {
                String result = "";
                String name = processDefinitionRef.getName();
                String s = name.indexOf("}") > 0 ? name.substring(name.lastIndexOf("}") + 1, name.length()) : name;
                String color = processDefinitionRef.isSuspended() ? "#CCCCCC" : "#000000";
                String text = "<div style=\"color:" + color + "\">" + s + "</div>";
                result = result + new HTML(text);
                result = result + " ";
                result = result + String.valueOf(processDefinitionRef.getVersion());
                result = result + " ";
                result = result + String.valueOf(processDefinitionRef.isSuspended());
                return result;
            }
        });
        listBox.setFirstLine("<b>Process</b>, v.");
        listBox.setFocus(true);
        listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int index = listBox.getSelectedIndex();
                if (index != -1) {
                    ProcessDefinitionRef processDefinitionRef = (ProcessDefinitionRef)listBox.getItem(index);
                }
            }
        });
        return listBox;
    }

    public void setController(Controller controller) {
    }

    @Override
    public void reset() {
        this.listBox.clear();
    }

    @Override
    public void update(Object ... data) {
        this.definitions = (List)data[0];
        this.pagingPanel.reset();
        this.renderFiltered();
    }

    @Override
    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.panel, isLoading);
    }

    private void renderFiltered() {
        if (this.definitions != null) {
            this.reset();
            ArrayList<ProcessDefinitionRef> tmp = new ArrayList<ProcessDefinitionRef>();
            for (ProcessDefinitionRef def : this.definitions) {
                tmp.add(def);
            }
            for (ProcessDefinitionRef def : this.pagingPanel.trim(tmp)) {
                this.listBox.addItem(def);
            }
        }
    }

    public ProcessDefinitionRef getSelection() {
        ProcessDefinitionRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }
}

