/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.ModelCommands;
import org.jboss.bpm.console.client.common.ModelParts;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.process.ClearInstancesAction;
import org.jboss.bpm.console.client.process.DeleteDefinitionAction;
import org.jboss.bpm.console.client.process.DeleteInstanceAction;
import org.jboss.bpm.console.client.process.StartNewInstanceAction;
import org.jboss.bpm.console.client.process.StateChangeAction;
import org.jboss.bpm.console.client.process.UpdateDefinitionsAction;
import org.jboss.bpm.console.client.process.UpdateInstancesAction;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.Message;
import org.jboss.errai.bus.client.api.MessageCallback;

@Deprecated
public class DefinitionListView
implements IsWidget,
ViewInterface,
DataDriven {
    public static final String ID = DefinitionListView.class.getName();
    private VerticalPanel definitionList = null;
    private CustomizableListBox<ProcessDefinitionRef> listBox;
    private boolean isInitialized;
    private int FILTER_NONE = 10;
    private int FILTER_ACTIVE = 20;
    private int FILTER_SUSPENDED = 30;
    private int currentFilter = this.FILTER_NONE;
    private List<ProcessDefinitionRef> definitions = null;
    private PagingPanel pagingPanel;
    private final SimplePanel panel = new SimplePanel();
    private final Controller controller;
    private final ApplicationContext applicationContext;

    public DefinitionListView(ClientFactory clientFactory) {
        this.controller = clientFactory.getController();
        this.applicationContext = clientFactory.getApplicationContext();
    }

    public Widget asWidget() {
        this.panel.clear();
        this.listBox = this.createListBox();
        this.controller.addView(ID, (ViewInterface)this);
        this.controller.addAction(UpdateInstancesAction.ID, (ActionInterface)new UpdateInstancesAction(this.applicationContext));
        this.controller.addAction(StartNewInstanceAction.ID, (ActionInterface)new StartNewInstanceAction(this.applicationContext));
        this.controller.addAction(StateChangeAction.ID, (ActionInterface)new StateChangeAction(this.applicationContext));
        this.controller.addAction(DeleteDefinitionAction.ID, (ActionInterface)new DeleteDefinitionAction(this.applicationContext));
        this.controller.addAction(DeleteInstanceAction.ID, (ActionInterface)new DeleteInstanceAction(this.applicationContext));
        this.controller.addAction(UpdateDefinitionsAction.ID, (ActionInterface)new UpdateDefinitionsAction(this.applicationContext));
        this.initialize();
        Timer t = new Timer(){

            public void run() {
                DefinitionListView.this.controller.handleEvent(new Event(UpdateDefinitionsAction.ID, null));
            }
        };
        t.schedule(500);
        return this.panel;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.definitionList = new VerticalPanel();
            HorizontalPanel toolBox = new HorizontalPanel();
            MenuBar toolBar = new MenuBar();
            toolBar.addItem("Refresh", new Command(){

                public void execute() {
                    DefinitionListView.this.reload();
                }
            });
            toolBox.add((Widget)toolBar);
            VerticalPanel filterPanel = new VerticalPanel();
            filterPanel.setStyleName("mosaic-ToolBar");
            final ListBox dropBox = new ListBox(false);
            dropBox.setStyleName("bpm-operation-ui");
            dropBox.addItem("All");
            dropBox.addItem("Active");
            dropBox.addItem("Retired");
            dropBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent changeEvent) {
                    switch (dropBox.getSelectedIndex()) {
                        case 0: {
                            DefinitionListView.this.currentFilter = DefinitionListView.this.FILTER_NONE;
                            break;
                        }
                        case 1: {
                            DefinitionListView.this.currentFilter = DefinitionListView.this.FILTER_ACTIVE;
                            break;
                        }
                        case 2: {
                            DefinitionListView.this.currentFilter = DefinitionListView.this.FILTER_SUSPENDED;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("No such index");
                        }
                    }
                    DefinitionListView.this.renderFiltered();
                }
            });
            filterPanel.add((Widget)dropBox);
            toolBox.add((Widget)filterPanel);
            this.definitionList.add((Widget)toolBox);
            this.definitionList.add(this.listBox);
            this.pagingPanel = new PagingPanel(new PagingCallback(){

                public void rev() {
                    DefinitionListView.this.renderFiltered();
                }

                public void ffw() {
                    DefinitionListView.this.renderFiltered();
                }
            });
            this.definitionList.add((Widget)this.pagingPanel);
            this.panel.add((Widget)this.definitionList);
            ErraiBus.get().subscribe("appContext.model.listener", new MessageCallback(){

                public void callback(Message message) {
                    switch (ModelCommands.valueOf(message.getCommandType())) {
                        case HAS_BEEN_UPDATED: {
                            if (!((String)message.get(String.class, (Enum)ModelParts.CLASS)).equals("deploymentModel")) break;
                            DefinitionListView.this.reload();
                        }
                    }
                }
            });
            this.isInitialized = true;
        }
    }

    private void reload() {
        DeferredCommand.addCommand((Command)new Command(){

            public void execute() {
                DefinitionListView.this.listBox.clear();
                DefinitionListView.this.controller.handleEvent(new Event(UpdateDefinitionsAction.ID, null));
            }
        });
    }

    private CustomizableListBox createListBox() {
        final CustomizableListBox<ProcessDefinitionRef> listBox = new CustomizableListBox<ProcessDefinitionRef>(new CustomizableListBox.ItemFormatter<ProcessDefinitionRef>(){

            @Override
            public String format(ProcessDefinitionRef processDefinitionRef) {
                String result = "";
                String name = processDefinitionRef.getName();
                String s = name.indexOf("}") > 0 ? name.substring(name.lastIndexOf("}") + 1, name.length()) : name;
                String color = processDefinitionRef.isSuspended() ? "#CCCCCC" : "#000000";
                String text = "<div style=\"color:" + color + "\">" + s + "</div>";
                result = result + new HTML(text);
                result = result + " ";
                result = result + String.valueOf(processDefinitionRef.getVersion());
                result = result + " ";
                result = result + String.valueOf(processDefinitionRef.isSuspended());
                return result;
            }
        });
        listBox.setFirstLine("<b>Process</b>, v.");
        listBox.setFocus(true);
        listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int index = listBox.getSelectedIndex();
                if (index != -1) {
                    ProcessDefinitionRef item = (ProcessDefinitionRef)listBox.getItem(index);
                    DefinitionListView.this.controller.handleEvent(new Event(UpdateInstancesAction.ID, (Object)item));
                }
            }
        });
        return listBox;
    }

    public void setController(Controller controller) {
    }

    public void reset() {
        this.listBox.clear();
        this.controller.handleEvent(new Event(ClearInstancesAction.ID, null));
    }

    public void update(Object ... data) {
        this.definitions = (List)data[0];
        this.pagingPanel.reset();
        this.renderFiltered();
    }

    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.panel, isLoading);
    }

    private void renderFiltered() {
        if (this.definitions != null) {
            this.reset();
            ArrayList<ProcessDefinitionRef> tmp = new ArrayList<ProcessDefinitionRef>();
            for (ProcessDefinitionRef def : this.definitions) {
                boolean showSuspended;
                if (this.FILTER_NONE == this.currentFilter) {
                    tmp.add(def);
                    continue;
                }
                boolean bl = showSuspended = this.FILTER_SUSPENDED == this.currentFilter;
                if (def.isSuspended() != showSuspended) continue;
                tmp.add(def);
            }
            for (ProcessDefinitionRef def : this.pagingPanel.trim(tmp)) {
                this.listBox.addItem(def);
            }
        }
    }

    public ProcessDefinitionRef getSelection() {
        ProcessDefinitionRef selection = null;
        if (this.isInitialized() && this.listBox.getSelectedIndex() != -1) {
            selection = this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }
}

