/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.model.HistoryActivityInstanceRef;
import org.jboss.bpm.console.client.model.HistoryProcessInstanceRef;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.process.ActivityDiagramView;
import org.jboss.bpm.console.client.process.LoadHistoryDiagramAction;
import org.jboss.bpm.console.client.process.UpdateHistoryDefinitionAction;
import org.jboss.bpm.console.client.process.UpdateHistoryInstanceAction;
import org.jboss.bpm.console.client.process.events.HistoryActivityDiagramEvent;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryInstanceListView
implements IsWidget,
ViewInterface,
DataDriven {
    public static final String ID = HistoryInstanceListView.class.getName();
    private Controller controller;
    private VerticalPanel instanceList = null;
    private CustomizableListBox<HistoryProcessInstanceRef> listBoxHistory;
    private CustomizableListBox<HistoryActivityInstanceRef> listBoxInstanceActivity;
    private ProcessDefinitionRef currentDefinition;
    private boolean isInitialized;
    private List<HistoryProcessInstanceRef> cachedInstances = null;
    private List<HistoryActivityInstanceRef> cachedInstancesActivity = null;
    private List<String> executedActivities = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ApplicationContext appContext;
    private PagingPanel pagingPanel;
    SimplePanel panel;
    private MenuItem diagramBtn;
    private WidgetWindowPanel diagramWindowPanel;
    private ActivityDiagramView diagramView;

    public HistoryInstanceListView(ClientFactory clientFactory) {
        this.appContext = clientFactory.getApplicationContext();
        this.controller = clientFactory.getController();
    }

    public Widget asWidget() {
        this.panel = new SimplePanel();
        this.controller.addView(ID, (ViewInterface)this);
        this.initialize();
        return this.panel;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.instanceList = new VerticalPanel();
            this.listBoxHistory = this.createHistoryListBox();
            this.listBoxInstanceActivity = this.createHistoryActivitiesListBox();
            HorizontalPanel toolBox = new HorizontalPanel();
            toolBox.setSpacing(5);
            MenuBar toolBar = new MenuBar();
            toolBar.addItem("Refresh", new Command(){

                public void execute() {
                    HistoryInstanceListView.this.controller.handleEvent(new Event(UpdateHistoryDefinitionAction.ID, (Object)HistoryInstanceListView.this.getCurrentDefinition()));
                }
            });
            this.diagramBtn = new MenuItem("Diagram", new Command(){

                public void execute() {
                    String diagramUrl = HistoryInstanceListView.this.currentDefinition.getDiagramUrl();
                    if (HistoryInstanceListView.this.currentDefinition != null && HistoryInstanceListView.this.executedActivities != null) {
                        HistoryActivityDiagramEvent eventData = new HistoryActivityDiagramEvent(HistoryInstanceListView.this.currentDefinition, HistoryInstanceListView.this.executedActivities);
                        if (diagramUrl != null && !diagramUrl.equals("")) {
                            HistoryInstanceListView.this.createDiagramWindow();
                            HistoryInstanceListView.this.controller.handleEvent(new Event(LoadHistoryDiagramAction.ID, (Object)eventData));
                        } else {
                            Window.alert((String)"Incomplete deployment, No diagram associated with process");
                        }
                    }
                }
            });
            toolBar.addItem(this.diagramBtn);
            this.diagramBtn.setEnabled(false);
            toolBox.add((Widget)toolBar);
            this.instanceList.add((Widget)toolBox);
            this.instanceList.add(this.listBoxHistory);
            this.pagingPanel = new PagingPanel(new PagingCallback(){

                public void rev() {
                    HistoryInstanceListView.this.renderUpdate();
                }

                public void ffw() {
                    HistoryInstanceListView.this.renderUpdate();
                }
            });
            this.instanceList.add((Widget)this.pagingPanel);
            this.instanceList.add(this.listBoxInstanceActivity);
            if (this.cachedInstances != null) {
                this.bindData(this.cachedInstances);
            }
            SimplePanel layout = new SimplePanel();
            layout.add((Widget)this.instanceList);
            this.panel.add((Widget)layout);
            this.isInitialized = true;
            this.executedActivities = new ArrayList<String>();
        }
    }

    public HistoryProcessInstanceRef getSelection() {
        HistoryProcessInstanceRef selection = null;
        if (this.listBoxHistory.getSelectedIndex() != -1) {
            selection = this.listBoxHistory.getItem(this.listBoxHistory.getSelectedIndex());
        }
        return selection;
    }

    public ProcessDefinitionRef getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.diagramView = new ActivityDiagramView();
        controller.addView(ActivityDiagramView.ID, (ViewInterface)this.diagramView);
    }

    @Override
    public void reset() {
        this.currentDefinition = null;
        this.cachedInstances = new ArrayList<HistoryProcessInstanceRef>();
        this.renderUpdate();
        this.diagramBtn.setEnabled(false);
    }

    @Override
    public void update(Object ... data) {
        if (data[0] instanceof ProcessDefinitionRef) {
            this.currentDefinition = (ProcessDefinitionRef)data[0];
            this.cachedInstances = (List)data[1];
            this.renderUpdate();
            this.listBoxInstanceActivity.clear();
            this.diagramBtn.setEnabled(false);
        } else {
            this.cachedInstancesActivity = (List)data[0];
            this.renderHistoryActivityList();
        }
    }

    @Override
    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.instanceList, isLoading);
    }

    private void renderUpdate() {
        if (this.isInitialized()) {
            this.bindData(this.cachedInstances);
        }
    }

    private void bindData(List<HistoryProcessInstanceRef> instances) {
        this.listBoxHistory.clear();
        List list = this.pagingPanel.trim(instances);
        for (HistoryProcessInstanceRef inst : list) {
            this.listBoxHistory.addItem(inst);
        }
    }

    private void renderHistoryActivityList() {
        if (this.cachedInstancesActivity != null) {
            this.listBoxInstanceActivity.clear();
            this.executedActivities.clear();
            for (HistoryActivityInstanceRef def : this.cachedInstancesActivity) {
                this.listBoxInstanceActivity.addItem(def);
                this.executedActivities.add(def.getActivityName());
            }
        }
    }

    protected CustomizableListBox<HistoryProcessInstanceRef> createHistoryListBox() {
        this.listBoxHistory = new CustomizableListBox<HistoryProcessInstanceRef>(new CustomizableListBox.ItemFormatter<HistoryProcessInstanceRef>(){

            @Override
            public String format(HistoryProcessInstanceRef historyProcessInstanceRef) {
                String result = "";
                result = result + historyProcessInstanceRef.getProcessInstanceId();
                result = result + " ";
                result = result + historyProcessInstanceRef.getState().toString();
                result = result + " ";
                result = result + (historyProcessInstanceRef.getStartTime() != null ? HistoryInstanceListView.this.dateFormat.format(historyProcessInstanceRef.getStartTime()) : "");
                result = result + " ";
                result = result + (historyProcessInstanceRef.getEndTime() != null ? HistoryInstanceListView.this.dateFormat.format(historyProcessInstanceRef.getEndTime()) : "");
                result = result + " ";
                result = result + String.valueOf(historyProcessInstanceRef.getDuration());
                return result;
            }
        });
        this.listBoxHistory.setFirstLine("<b>Instance</b>, State, Start Date, End Date, Duration");
        this.listBoxHistory.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int index = HistoryInstanceListView.this.listBoxHistory.getSelectedIndex();
                if (index != -1) {
                    HistoryProcessInstanceRef item = (HistoryProcessInstanceRef)HistoryInstanceListView.this.listBoxHistory.getItem(index);
                    HistoryInstanceListView.this.controller.handleEvent(new Event(UpdateHistoryInstanceAction.ID, (Object)item.getProcessInstanceId()));
                    HistoryInstanceListView.this.diagramBtn.setEnabled(true);
                }
            }
        });
        return this.listBoxHistory;
    }

    private CustomizableListBox<HistoryActivityInstanceRef> createHistoryActivitiesListBox() {
        CustomizableListBox<HistoryActivityInstanceRef> listBox = new CustomizableListBox<HistoryActivityInstanceRef>(new CustomizableListBox.ItemFormatter<HistoryActivityInstanceRef>(){

            @Override
            public String format(HistoryActivityInstanceRef historyActivityInstanceRef) {
                String result = "";
                result = result + historyActivityInstanceRef.getActivityName();
                result = result + " ";
                result = result + (historyActivityInstanceRef.getStartTime() != null ? HistoryInstanceListView.this.dateFormat.format(historyActivityInstanceRef.getStartTime()) : "");
                result = result + " ";
                result = result + (historyActivityInstanceRef.getEndTime() != null ? HistoryInstanceListView.this.dateFormat.format(historyActivityInstanceRef.getEndTime()) : "");
                result = result + " ";
                result = result + String.valueOf(historyActivityInstanceRef.getDuration());
                return result;
            }
        });
        listBox.setFirstLine("ActivityName, StartTime, EndTime, Duration");
        return listBox;
    }

    private void createDiagramWindow() {
        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName("bpm-window-layout");
        Label header = new Label("Instance: ");
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header);
        layout.add((Widget)this.diagramView);
        this.diagramWindowPanel = new WidgetWindowPanel("Process Instance Activity", (Widget)layout, true);
    }
}

