/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.NamedNodeMap;
import com.google.gwt.xml.client.Node;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.process.JSONTree;
import org.jboss.bpm.console.client.util.ConsoleLog;
import org.jboss.bpm.console.client.util.DOMUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceDataView
extends SimplePanel
implements ViewInterface,
LazyPanel {
    public static final String ID = InstanceDataView.class.getName();
    private Controller controller;
    private CustomizableListBox<DataEntry> listBox;
    private String instanceId;
    private boolean isInitialized;
    boolean isRiftsawInstance = false;

    public InstanceDataView(ClientFactory clientFactory) {
        this.isRiftsawInstance = clientFactory.getApplicationContext().getConfig().getProfileName().equals("BPEL Console");
    }

    @Override
    public void initialize() {
        if (!this.isInitialized) {
            this.listBox = new CustomizableListBox<DataEntry>(new CustomizableListBox.ItemFormatter<DataEntry>(){

                @Override
                public String format(DataEntry node) {
                    String result = "";
                    result = result + node.key;
                    result = result + " ";
                    result = result + node.xsd;
                    result = result + " ";
                    result = result + node.java;
                    result = result + " ";
                    if (InstanceDataView.this.isRiftsawInstance) {
                        JSONTree tree = new JSONTree(node.value);
                        result = result + (Object)((Object)tree);
                    } else {
                        result = result + node.value;
                    }
                    return result;
                }
            });
            this.listBox.setFirstLine("Key, XSD Type, Java Type, Value");
            this.add(this.listBox);
            this.isInitialized = true;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void update(String instanceId, Document xml) {
        this.instanceId = instanceId;
        this.parseMessage(xml);
    }

    private void parseMessage(Document messageDom) {
        try {
            Node dataSetNode = messageDom.getElementsByTagName("dataset").item(0);
            List<Node> dataSetNodeChildren = DOMUtil.getChildElements(dataSetNode.getChildNodes());
            ArrayList<DataEntry> results = new ArrayList<DataEntry>();
            for (Node dataNode : dataSetNodeChildren) {
                DataEntry dataEntry = new DataEntry();
                NamedNodeMap dataNodeAttributes = dataNode.getAttributes();
                Node valueNode = DOMUtil.getChildElements(dataNode.getChildNodes()).get(0);
                NamedNodeMap valueNodeAttributes = valueNode.getAttributes();
                dataEntry.key = dataNodeAttributes.getNamedItem("key").getNodeValue();
                dataEntry.java = dataNodeAttributes.getNamedItem("javaType").getNodeValue();
                dataEntry.xsd = valueNodeAttributes.getNamedItem("xsi:type").getNodeValue();
                List<Node> valueChildElements = DOMUtil.getChildElements(valueNode.getChildNodes());
                dataEntry.value = valueChildElements.isEmpty() && valueNode.hasChildNodes() && 3 == valueNode.getChildNodes().item(0).getNodeType() ? valueNode.getFirstChild().getNodeValue() : "n/a";
                results.add(dataEntry);
            }
            this.bindData(results);
        }
        catch (Throwable e) {
            ConsoleLog.error("Failed to parse XML document", e);
        }
    }

    private void bindData(List<DataEntry> data) {
        this.initialize();
        this.listBox.clear();
        for (DataEntry d : data) {
            this.listBox.addItem(d);
        }
    }

    private class DataEntry {
        String key;
        String xsd;
        String java;
        String value;

        private DataEntry() {
        }
    }
}

