/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.PropertyGrid;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.StringRef;
import org.jboss.bpm.console.client.process.ActivityDiagramView;
import org.jboss.bpm.console.client.process.GetProcessInstanceEventsAction;
import org.jboss.bpm.console.client.process.InstanceDataView;
import org.jboss.bpm.console.client.process.LoadActivityDiagramAction;
import org.jboss.bpm.console.client.process.LoadInstanceActivityImage;
import org.jboss.bpm.console.client.process.UpdateInstanceDataAction;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceDetailView
extends HorizontalPanel
implements ViewInterface {
    public static final String ID = InstanceDetailView.class.getName();
    private Controller controller;
    private PropertyGrid grid;
    private ProcessInstanceRef currentInstance;
    private Button diagramBtn;
    private Button instanceDataBtn;
    private WidgetWindowPanel diagramWindowPanel;
    private WidgetWindowPanel instanceDataWindowPanel;
    private ApplicationContext appContext;
    private ActivityDiagramView diagramView;
    private InstanceDataView instanceDataView;
    private boolean hasDiagramPlugin;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ProcessDefinitionRef currentDefintion;
    private boolean isRiftsawInstance;
    private CustomizableListBox<String> processEvents;
    private final ClientFactory clientFactory;

    public InstanceDetailView(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.controller = clientFactory.getController();
        this.controller.addView(ID, (ViewInterface)this);
        this.controller.addAction(GetProcessInstanceEventsAction.ID, (ActionInterface)new GetProcessInstanceEventsAction(clientFactory.getApplicationContext()));
        this.appContext = clientFactory.getApplicationContext();
        this.isRiftsawInstance = this.appContext.getConfig().getProfileName().equals("BPEL Console");
        super.setStyleName("bpm-detail-panel");
        this.grid = new PropertyGrid(new String[]{"Process:", "Instance ID:", "State", "Start Date:", "Activity:"});
        this.add((Widget)this.grid);
        VerticalPanel buttonPanel = new VerticalPanel();
        this.diagramBtn = new Button("Execution Path", new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                String diagramUrl = InstanceDetailView.this.getCurrentDefintion().getDiagramUrl();
                if (diagramUrl != null && !diagramUrl.equals("")) {
                    final ProcessInstanceRef selection = InstanceDetailView.this.getCurrentInstance();
                    if (selection != null) {
                        InstanceDetailView.this.createDiagramWindow(selection);
                        DeferredCommand.addCommand((Command)new Command(){

                            public void execute() {
                                InstanceDetailView.this.controller.handleEvent(new Event(LoadInstanceActivityImage.class.getName(), (Object)selection));
                            }
                        });
                    }
                } else {
                    Window.alert((String)"Incomplete deployment. No diagram associated with process");
                }
            }
        });
        this.diagramBtn.setEnabled(false);
        buttonPanel.add((Widget)this.diagramBtn);
        this.instanceDataBtn = new Button("Instance Data", new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                if (InstanceDetailView.this.currentInstance != null) {
                    InstanceDetailView.this.createDataWindow(InstanceDetailView.this.currentInstance);
                    InstanceDetailView.this.controller.handleEvent(new Event(UpdateInstanceDataAction.ID, (Object)InstanceDetailView.this.currentInstance.getId()));
                }
            }
        });
        this.instanceDataBtn.setEnabled(false);
        buttonPanel.add((Widget)this.instanceDataBtn);
        this.add((Widget)buttonPanel);
        this.hasDiagramPlugin = ServerPlugins.has("org.jboss.bpm.console.server.plugin.GraphViewerPlugin");
    }

    private void createDiagramWindow(ProcessInstanceRef inst) {
        ScrollPanel layout = new ScrollPanel();
        layout.setStyleName("bpm-window-layout");
        Label header = new Label("Instance: " + inst.getId());
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header);
        TabPanel tabPanel = new TabPanel();
        HorizontalPanel diaViewLayout = new HorizontalPanel();
        diaViewLayout.add((Widget)this.diagramView);
        tabPanel.add((Widget)this.diagramView, "View");
        this.processEvents = new CustomizableListBox<String>(new CustomizableListBox.ItemFormatter<String>(){

            @Override
            public String format(String item) {
                return new HTML(item).getHTML();
            }
        });
        this.processEvents.setFirstLine("Process Events");
        VerticalPanel sourcePanel = new VerticalPanel();
        sourcePanel.add(this.processEvents);
        tabPanel.add((Widget)sourcePanel, "Source");
        tabPanel.selectTab(0);
        layout.add((Widget)tabPanel);
        this.diagramWindowPanel = new WidgetWindowPanel("Process Instance Activity", (Widget)layout, true);
        this.controller.handleEvent(new Event(GetProcessInstanceEventsAction.ID, (Object)inst.getId()));
    }

    public void populateProcessInstanceEvents(List<StringRef> refs) {
        this.processEvents.clear();
        for (StringRef value : refs) {
            this.processEvents.addItem(this.formatResult(value.getValue()));
        }
    }

    private String formatResult(String value) {
        StringBuffer sbuffer = new StringBuffer();
        String[] split = value.split("~");
        sbuffer.append(split[0] + " : ");
        for (int i = 1; i < split.length; ++i) {
            sbuffer.append("<br/>");
            sbuffer.append(split[i]);
        }
        return sbuffer.toString();
    }

    private void createDataWindow(ProcessInstanceRef inst) {
        this.instanceDataWindowPanel = new WidgetWindowPanel("Process Instance Data: " + inst.getId(), (Widget)this.instanceDataView, true);
    }

    public void setController(Controller controller) {
        this.controller = controller;
        this.diagramView = new ActivityDiagramView();
        this.instanceDataView = new InstanceDataView(this.clientFactory);
        controller.addView(ActivityDiagramView.ID, (ViewInterface)this.diagramView);
        controller.addView(InstanceDataView.ID, (ViewInterface)this.instanceDataView);
        controller.addAction(LoadActivityDiagramAction.ID, (ActionInterface)new LoadActivityDiagramAction(this.clientFactory.getApplicationContext()));
        controller.addAction(LoadInstanceActivityImage.class.getName(), (ActionInterface)new LoadInstanceActivityImage(this.clientFactory.getApplicationContext()));
        controller.addAction(UpdateInstanceDataAction.ID, (ActionInterface)new UpdateInstanceDataAction(this.clientFactory.getApplicationContext()));
    }

    public void update(ProcessDefinitionRef def, ProcessInstanceRef instance) {
        this.currentDefintion = def;
        this.currentInstance = instance;
        String currentNodeName = instance.getRootToken() != null ? instance.getRootToken().getCurrentNodeName() : "n/a";
        String[] values = new String[]{def.getName(), instance.getId(), String.valueOf(instance.getState()), this.dateFormat.format(instance.getStartDate()), currentNodeName};
        this.grid.update(values);
        if (this.hasDiagramPlugin) {
            this.diagramBtn.setEnabled(true);
        }
        this.instanceDataBtn.setEnabled(true);
    }

    public void clearView() {
        this.grid.clear();
        this.currentDefintion = null;
        this.currentInstance = null;
        this.diagramBtn.setEnabled(false);
        this.instanceDataBtn.setEnabled(false);
    }

    private ProcessDefinitionRef getCurrentDefintion() {
        return this.currentDefintion;
    }

    private ProcessInstanceRef getCurrentInstance() {
        return this.currentInstance;
    }
}

