/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.process;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.IFrameWindowCallback;
import org.jboss.bpm.console.client.common.IFrameWindowPanel;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.WidgetWindowPanel;
import org.jboss.bpm.console.client.icons.ConsoleIconBundle;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.TokenReference;
import org.jboss.bpm.console.client.process.ClearInstancesAction;
import org.jboss.bpm.console.client.process.DeleteInstanceAction;
import org.jboss.bpm.console.client.process.InstanceDetailView;
import org.jboss.bpm.console.client.process.SignalExecutionAction;
import org.jboss.bpm.console.client.process.StartNewInstanceAction;
import org.jboss.bpm.console.client.process.StateChangeAction;
import org.jboss.bpm.console.client.process.UpdateInstanceDetailAction;
import org.jboss.bpm.console.client.process.UpdateInstancesAction;
import org.jboss.bpm.console.client.process.events.InstanceEvent;
import org.jboss.bpm.console.client.process.events.SignalInstanceEvent;
import org.jboss.bpm.console.client.util.SimpleDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceListView
implements IsWidget,
ViewInterface,
DataDriven {
    public static final String ID = InstanceListView.class.getName();
    private Controller controller;
    private VerticalPanel instanceList = null;
    private CustomizableListBox<ProcessInstanceRef> listBox;
    private ProcessDefinitionRef currentDefinition;
    private boolean isInitialized;
    private List<ProcessInstanceRef> cachedInstances = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private ApplicationContext appContext;
    private IFrameWindowPanel iframeWindow = null;
    private boolean isRiftsawInstance;
    SimplePanel panel;
    private MenuItem startBtn;
    private MenuItem terminateBtn;
    private MenuItem deleteBtn;
    private MenuItem signalBtn;
    private MenuItem refreshBtn;
    private List<TokenReference> tokensToSignal = null;
    private WidgetWindowPanel signalWindowPanel;
    private CustomizableListBox<TokenReference> listBoxTokens = null;
    private List<TextBox> signalTextBoxes = null;
    private CustomizableListBox<String> listBoxTokenSignals;
    private ImageResource greenIcon;
    private final ClientFactory clientFactory;

    public InstanceListView(ClientFactory clientFactory) {
        this.appContext = clientFactory.getApplicationContext();
        this.clientFactory = clientFactory;
        this.isRiftsawInstance = clientFactory.getApplicationContext().getConfig().getProfileName().equals("BPEL Console");
        this.controller = clientFactory.getController();
    }

    public Widget asWidget() {
        this.panel = new SimplePanel();
        this.controller.addView(ID, (ViewInterface)this);
        this.initialize();
        ConsoleIconBundle imageBundle = (ConsoleIconBundle)GWT.create(ConsoleIconBundle.class);
        this.greenIcon = imageBundle.greenIcon();
        return this.panel;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.instanceList = new VerticalPanel();
            this.listBox = new CustomizableListBox<ProcessInstanceRef>(new CustomizableListBox.ItemFormatter<ProcessInstanceRef>(){

                @Override
                public String format(ProcessInstanceRef processInstanceRef) {
                    String result = "";
                    result = result + processInstanceRef.getId();
                    result = result + " ";
                    result = result + processInstanceRef.getState().toString();
                    result = result + " ";
                    result = result + (processInstanceRef.getStartDate() != null ? InstanceListView.this.dateFormat.format(processInstanceRef.getStartDate()) : "");
                    return result;
                }
            });
            this.listBox.setFirstLine("<b>Instance</b>, State, Start Date");
            this.listBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    int index = InstanceListView.this.listBox.getSelectedIndex();
                    if (index != -1) {
                        ProcessInstanceRef item = (ProcessInstanceRef)InstanceListView.this.listBox.getItem(index);
                        if (InstanceListView.this.isSignalable(item)) {
                            InstanceListView.this.signalBtn.setEnabled(true);
                        } else {
                            InstanceListView.this.signalBtn.setEnabled(false);
                        }
                        InstanceListView.this.terminateBtn.setEnabled(true);
                        InstanceListView.this.controller.handleEvent(new Event(UpdateInstanceDetailAction.ID, (Object)new InstanceEvent(InstanceListView.this.currentDefinition, item)));
                    }
                }
            });
            VerticalPanel toolBox = new VerticalPanel();
            toolBox.setSpacing(5);
            MenuBar toolBar = new MenuBar();
            this.refreshBtn = new MenuItem("Refresh", new Command(){

                public void execute() {
                    InstanceListView.this.controller.handleEvent(new Event(UpdateInstancesAction.ID, (Object)InstanceListView.this.getCurrentDefinition()));
                }
            });
            toolBar.addItem(this.refreshBtn);
            this.refreshBtn.setEnabled(false);
            toolBar.addSeparator();
            this.startBtn = new MenuItem("Start", new Command(){

                public void execute() {
                    if (Window.confirm((String)"Start new execution. Do you want to start a new execution of this process?")) {
                        boolean hasForm;
                        String url = InstanceListView.this.getCurrentDefinition().getFormUrl();
                        boolean bl = hasForm = url != null && !url.equals("");
                        if (hasForm) {
                            ProcessDefinitionRef definition = InstanceListView.this.getCurrentDefinition();
                            InstanceListView.this.iframeWindow = new IFrameWindowPanel(definition.getFormUrl(), "New Process Instance: " + definition.getId());
                            InstanceListView.this.iframeWindow.setCallback(new IFrameWindowCallback(){

                                public void onWindowClosed() {
                                    InstanceListView.this.controller.handleEvent(new Event(UpdateInstancesAction.ID, (Object)InstanceListView.this.getCurrentDefinition()));
                                }
                            });
                            InstanceListView.this.iframeWindow.show();
                        } else {
                            InstanceListView.this.controller.handleEvent(new Event(StartNewInstanceAction.ID, (Object)InstanceListView.this.getCurrentDefinition()));
                        }
                    }
                }
            });
            this.terminateBtn = new MenuItem("Terminate", new Command(){

                public void execute() {
                    if (InstanceListView.this.getSelection() != null) {
                        if (Window.confirm((String)"Terminate instance. Terminating this instance will stop further execution.")) {
                            ProcessInstanceRef selection = InstanceListView.this.getSelection();
                            selection.setState(ProcessInstanceRef.STATE.ENDED);
                            selection.setEndResult(ProcessInstanceRef.RESULT.OBSOLETE);
                            InstanceListView.this.controller.handleEvent(new Event(StateChangeAction.ID, (Object)selection));
                        }
                    } else {
                        Window.alert((String)"Missing selection. Please select an instance");
                    }
                }
            });
            this.deleteBtn = new MenuItem("Delete", new Command(){

                public void execute() {
                    if (InstanceListView.this.getSelection() != null) {
                        if (Window.confirm((String)"Delete instance. Deleting this instance will remove any history information and associated tasks as well.")) {
                            ProcessInstanceRef selection = InstanceListView.this.getSelection();
                            selection.setState(ProcessInstanceRef.STATE.ENDED);
                            InstanceListView.this.controller.handleEvent(new Event(DeleteInstanceAction.ID, (Object)selection));
                        } else {
                            Window.alert((String)"Missing selection. Please select an instance");
                        }
                    }
                }
            });
            this.signalBtn = new MenuItem("Signal", new Command(){

                public void execute() {
                    InstanceListView.this.createSignalWindow();
                }
            });
            if (!this.isRiftsawInstance) {
                toolBar.addItem(this.startBtn);
                toolBar.addItem(this.signalBtn);
                toolBar.addItem(this.deleteBtn);
                this.startBtn.setEnabled(false);
                this.deleteBtn.setEnabled(false);
                this.signalBtn.setEnabled(false);
            }
            toolBar.addItem(this.terminateBtn);
            this.terminateBtn.setEnabled(false);
            toolBox.add((Widget)toolBar);
            this.instanceList.add((Widget)toolBox);
            this.instanceList.add(this.listBox);
            if (this.cachedInstances != null) {
                this.bindData(this.cachedInstances);
            }
            HorizontalPanel layout = new HorizontalPanel();
            layout.add((Widget)this.instanceList);
            InstanceDetailView detailsView = new InstanceDetailView(this.clientFactory);
            this.controller.addView(InstanceDetailView.ID, (ViewInterface)detailsView);
            this.controller.addAction(UpdateInstanceDetailAction.ID, (ActionInterface)new UpdateInstanceDetailAction());
            this.controller.addAction(ClearInstancesAction.ID, (ActionInterface)new ClearInstancesAction());
            this.controller.addAction(SignalExecutionAction.ID, (ActionInterface)new SignalExecutionAction(this.clientFactory.getApplicationContext()));
            layout.add((Widget)detailsView);
            this.panel.add((Widget)layout);
            this.isInitialized = true;
        }
    }

    public ProcessInstanceRef getSelection() {
        ProcessInstanceRef selection = null;
        if (this.listBox.getSelectedIndex() != -1) {
            selection = this.listBox.getItem(this.listBox.getSelectedIndex());
        }
        return selection;
    }

    public ProcessDefinitionRef getCurrentDefinition() {
        return this.currentDefinition;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void reset() {
        this.currentDefinition = null;
        this.cachedInstances = new ArrayList<ProcessInstanceRef>();
        this.renderUpdate();
        this.startBtn.setEnabled(false);
        this.terminateBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
        this.signalBtn.setEnabled(false);
        this.refreshBtn.setEnabled(false);
    }

    @Override
    public void update(Object ... data) {
        this.currentDefinition = (ProcessDefinitionRef)data[0];
        this.cachedInstances = (List)data[1];
        this.renderUpdate();
    }

    @Override
    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.instanceList, isLoading);
    }

    private void renderUpdate() {
        if (this.isInitialized()) {
            this.bindData(this.cachedInstances);
            this.controller.handleEvent(new Event(UpdateInstanceDetailAction.ID, (Object)new InstanceEvent(this.currentDefinition, null)));
            this.startBtn.setEnabled(true);
            this.deleteBtn.setEnabled(true);
            this.refreshBtn.setEnabled(true);
        }
    }

    private void bindData(List<ProcessInstanceRef> instances) {
        this.listBox.clear();
        List<ProcessInstanceRef> list = instances;
        for (ProcessInstanceRef inst : list) {
            this.listBox.addItem(inst);
        }
    }

    private boolean isSignalable(ProcessInstanceRef processInstance) {
        this.tokensToSignal = new ArrayList<TokenReference>();
        if (processInstance.getRootToken() != null && processInstance.getRootToken().canBeSignaled()) {
            this.tokensToSignal.add(processInstance.getRootToken());
        } else if (processInstance.getRootToken() != null && processInstance.getRootToken().getChildren() != null) {
            this.collectSignalableTokens(processInstance.getRootToken(), this.tokensToSignal);
        }
        return this.tokensToSignal.size() > 0;
    }

    private void collectSignalableTokens(TokenReference tokenParent, List<TokenReference> tokensToSignal) {
        if (tokenParent.getChildren() != null) {
            for (TokenReference token : tokenParent.getChildren()) {
                if (token.canBeSignaled()) {
                    tokensToSignal.add(token);
                }
                this.collectSignalableTokens(token, tokensToSignal);
            }
        }
    }

    private void createSignalWindow() {
        this.signalTextBoxes = new ArrayList<TextBox>();
        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName("bpm-window-layout");
        HorizontalPanel toolBox = new HorizontalPanel();
        toolBox.setSpacing(5);
        MenuBar toolBar = new MenuBar();
        toolBar.addItem("Signal", new Command(){

            public void execute() {
                int selectedToken = InstanceListView.this.listBoxTokens.getSelectedIndex();
                int selectedSignal = InstanceListView.this.listBoxTokenSignals.getSelectedIndex();
                if (selectedToken != -1 && selectedSignal != -1) {
                    InstanceListView.this.controller.handleEvent(new Event(SignalExecutionAction.ID, (Object)new SignalInstanceEvent(InstanceListView.this.getCurrentDefinition(), InstanceListView.this.getSelection(), (TokenReference)InstanceListView.this.listBoxTokens.getItem(selectedToken), (String)InstanceListView.this.listBoxTokenSignals.getItem(selectedSignal), selectedToken)));
                } else {
                    Window.alert((String)"Incomplete selection. Please select both token and signal name");
                }
            }
        });
        toolBar.addItem("Cancel", new Command(){

            public void execute() {
                InstanceListView.this.signalWindowPanel.close();
            }
        });
        Label header = new Label("Available tokens to signal: ");
        header.setStyleName("bpm-label-header");
        layout.add((Widget)header);
        toolBox.add((Widget)toolBar);
        layout.add((Widget)toolBox);
        this.listBoxTokens = new CustomizableListBox<TokenReference>(new CustomizableListBox.ItemFormatter<TokenReference>(){

            @Override
            public String format(TokenReference tokenReference) {
                String result = "";
                result = result + tokenReference.getId();
                result = result + " ";
                result = result + (tokenReference.getName() == null ? tokenReference.getCurrentNodeName() : tokenReference.getName());
                return result;
            }
        });
        this.listBoxTokens.setFirstLine("Id, Name");
        this.listBoxTokens.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int index = InstanceListView.this.listBoxTokens.getSelectedIndex();
                if (index != -1) {
                    TokenReference item = (TokenReference)InstanceListView.this.listBoxTokens.getItem(index);
                    InstanceListView.this.renderAvailableSignals(item);
                }
            }
        });
        this.renderSignalListBox(-1);
        layout.add(this.listBoxTokens);
        Label headerSignals = new Label("Available signal names");
        headerSignals.setStyleName("bpm-label-header");
        layout.add((Widget)headerSignals);
        this.listBoxTokenSignals = new CustomizableListBox<String>(new CustomizableListBox.ItemFormatter<String>(){

            @Override
            public String format(String item) {
                return item;
            }
        });
        this.listBoxTokenSignals.setFirstLine("Signal name");
        layout.add(this.listBoxTokenSignals);
        this.signalWindowPanel = new WidgetWindowPanel("Signal process from wait state", (Widget)layout, true);
    }

    public void renderSignalListBox(int i) {
        if (i > -1) {
            this.tokensToSignal.remove(i);
        }
        if (this.tokensToSignal.isEmpty()) {
            this.signalWindowPanel.close();
        }
        this.listBoxTokens.clear();
        for (TokenReference token : this.tokensToSignal) {
            this.listBoxTokens.addItem(token);
        }
        if (this.listBoxTokenSignals != null) {
            this.listBoxTokenSignals.clear();
        }
    }

    private void renderAvailableSignals(TokenReference item) {
        this.listBoxTokenSignals.clear();
        for (String signal : item.getAvailableSignals()) {
            this.listBoxTokenSignals.addItem(signal);
        }
    }
}

