/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.report;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.URLBuilder;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.report.RenderDispatchEvent;
import org.jboss.bpm.console.client.report.RenderReportAction;
import org.jboss.bpm.console.client.report.ReportFrame;
import org.jboss.bpm.console.client.report.ReportParamCallback;
import org.jboss.bpm.console.client.report.ReportParameterForm;
import org.jboss.bpm.report.model.ReportReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReportLaunchPadView
extends VerticalPanel
implements ViewInterface,
DataDriven {
    public static final String ID = ReportLaunchPadView.class.getName();
    private Controller controller;
    private SimplePanel inputPanel;
    private ListBox dropBox;
    List<ReportReference> reportTemplates;
    private HTML description;
    private ReportFrame reportFrame;
    private Map<String, ReportParameterForm> forms = new HashMap<String, ReportParameterForm>();
    private final ClientFactory clientFactory;

    public ReportLaunchPadView(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        HorizontalPanel header = new HorizontalPanel();
        header.setStyleName("bpm-detail-panel");
        VerticalPanel templatePanel = new VerticalPanel();
        this.description = new HTML();
        this.dropBox = new ListBox(false);
        this.dropBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent changeEvent) {
                String reportTitle = ReportLaunchPadView.this.dropBox.getItemText(ReportLaunchPadView.this.dropBox.getSelectedIndex());
                ReportLaunchPadView.this.selectForm(reportTitle);
            }
        });
        templatePanel.add((Widget)this.dropBox);
        templatePanel.add((Widget)this.description);
        this.inputPanel = new SimplePanel();
        header.add((Widget)templatePanel);
        header.add((Widget)this.inputPanel);
        this.reportFrame = new ReportFrame();
        this.add((Widget)header);
        this.add((Widget)this.reportFrame);
    }

    private ReportParameterForm createInput(final ReportReference reportRef) {
        ReportParameterForm form = new ReportParameterForm(reportRef, new ReportParamCallback(){

            @Override
            public void onSumbit(Map<String, String> paramValues) {
                boolean valid = true;
                for (String key : paramValues.keySet()) {
                    String s = paramValues.get(key);
                    if (s != null && !s.equals("")) continue;
                    valid = false;
                }
                if (valid) {
                    String url = URLBuilder.getInstance().getReportURL(reportRef.getReportFileName());
                    RenderDispatchEvent eventPayload = new RenderDispatchEvent(reportRef.getTitle(), url);
                    eventPayload.setParameters(ReportLaunchPadView.fieldValues2PostParams(paramValues));
                    ReportLaunchPadView.this.controller.handleEvent(new Event(RenderReportAction.ID, (Object)eventPayload));
                } else {
                    Window.alert((String)"Report Parameters. Please provide the required input parameters");
                }
            }
        });
        return form;
    }

    private ReportReference getCurrentSelection() {
        String template = this.dropBox.getItemText(this.dropBox.getSelectedIndex());
        for (ReportReference r : this.reportTemplates) {
            if (!r.getTitle().equals(template)) continue;
            return r;
        }
        return null;
    }

    public void update(List<ReportReference> reports) {
        this.reportTemplates = reports;
        this.forms.clear();
        for (ReportReference report : reports) {
            this.dropBox.addItem(report.getTitle());
            this.forms.put(report.getTitle(), this.createInput(report));
        }
        this.dropBox.setSelectedIndex(0);
        this.selectForm(this.dropBox.getItemText(0));
        this.clientFactory.getApplicationContext().refreshView();
    }

    private void selectForm(String reportTitle) {
        this.inputPanel.clear();
        ReportReference current = this.getCurrentSelection();
        this.description.setText(current.getDescription());
        this.inputPanel.add((Widget)this.forms.get(reportTitle));
    }

    public void displayReport(String title, String dispatchUrl) {
        this.reportFrame.setFrameUrl(dispatchUrl);
    }

    @Override
    public void reset() {
        String url = GWT.getModuleBaseURL() + "blank.html";
        System.out.println("** Blank URL: " + url);
        this.displayReport("", url);
    }

    @Override
    public void update(Object ... data) {
        String title = (String)data[0];
        String url = (String)data[1];
        this.displayReport(title, url);
    }

    @Override
    public void setLoading(boolean isLoading) {
        LoadingOverlay.on((Widget)this.reportFrame, isLoading);
    }

    private static String fieldValues2PostParams(Map<String, String> values) {
        StringBuffer sb = new StringBuffer();
        for (String key : values.keySet()) {
            sb.append(key).append("=").append(values.get(key));
            sb.append(";");
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }
}

