/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.report.search;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.SuggestionEvent;
import com.google.gwt.user.client.ui.SuggestionHandler;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.report.search.SearchDelegate;
import org.jboss.bpm.console.client.report.search.SearchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDefinitionView
extends VerticalPanel
implements ViewInterface {
    private Controller controller;
    private ApplicationContext appContext;
    private SearchDelegate delegate;
    private SuggestBox suggestBox;
    private String selection = null;
    private SearchWindow parent;

    public SearchDefinitionView(ApplicationContext appContext, SearchDelegate delegate) {
        this.appContext = appContext;
        this.delegate = delegate;
        this.add((Widget)new Label("Loading, please wait..."));
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    private MultiWordSuggestOracle createOracle(List<ProcessDefinitionRef> definitions) {
        MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();
        for (ProcessDefinitionRef p : definitions) {
            oracle.add(p.getId());
        }
        return oracle;
    }

    public void update(List<ProcessDefinitionRef> definitions) {
        this.clear();
        this.selection = null;
        Label desc = new Label("Please enter a process definition ID");
        this.add((Widget)desc);
        this.suggestBox = new SuggestBox((SuggestOracle)this.createOracle(definitions));
        this.suggestBox.addEventHandler(new SuggestionHandler(){

            public void onSuggestionSelected(SuggestionEvent suggestionEvent) {
                SearchDefinitionView.this.selection = suggestionEvent.getSelectedSuggestion().getReplacementString();
            }
        });
        this.add((Widget)this.suggestBox);
        Grid g = new Grid(2, 2);
        g.setWidget(0, 0, (Widget)new Label("ID: "));
        g.setWidget(0, 1, (Widget)this.suggestBox);
        Button button = new Button(this.delegate.getActionName(), new ClickListener(){

            public void onClick(Widget widget) {
                if (SearchDefinitionView.this.selection != null) {
                    SearchDefinitionView.this.delegate.handleResult(SearchDefinitionView.this.selection);
                    SearchDefinitionView.this.parent.close();
                }
            }
        });
        g.setWidget(1, 1, (Widget)button);
        this.add((Widget)g);
    }

    void setParent(SearchWindow window) {
        this.parent = window;
    }
}

