/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.ServerPlugins;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.IFrameWindowCallback;
import org.jboss.bpm.console.client.common.IFrameWindowPanel;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.ModelCommands;
import org.jboss.bpm.console.client.common.ModelParts;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.AbstractTaskList;
import org.jboss.bpm.console.client.task.LoadTasksAction;
import org.jboss.bpm.console.client.task.OpenTasksView;
import org.jboss.bpm.console.client.task.ReleaseTaskAction;
import org.jboss.bpm.console.client.task.TaskDetailView;
import org.jboss.bpm.console.client.task.UpdateDetailsAction;
import org.jboss.bpm.console.client.task.events.DetailViewEvent;
import org.jboss.bpm.console.client.task.events.TaskIdentityEvent;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.Message;
import org.jboss.errai.bus.client.api.MessageCallback;

public class AssignedTasksView
extends AbstractTaskList
implements IsWidget,
DataDriven {
    public static final String ID = AssignedTasksView.class.getName();
    private final ApplicationContext appContext;
    private IFrameWindowPanel iframeWindow = null;
    private TaskDetailView detailsView;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private boolean hasDispatcherPlugin;
    private PagingPanel pagingPanel;
    private DockPanel panel;

    public AssignedTasksView(ClientFactory clientFactory) {
        this.appContext = clientFactory.getApplicationContext();
        this.controller = clientFactory.getController();
    }

    public Widget asWidget() {
        this.panel = new DockPanel();
        this.initialize();
        this.panel.add((Widget)this.detailsView, DockPanel.SOUTH);
        this.panel.add((Widget)this.taskList, DockPanel.CENTER);
        this.controller.addView(ID, (ViewInterface)this);
        return this.panel;
    }

    public void initialize() {
        if (!this.isInitialized) {
            OpenTasksView.registerCommonActions(this.appContext, this.controller);
            this.taskList = new VerticalPanel();
            this.listBox = new CustomizableListBox<TaskRef>(new CustomizableListBox.ItemFormatter<TaskRef>(){

                @Override
                public String format(TaskRef taskRef) {
                    String result = "";
                    result = result + String.valueOf(taskRef.getPriority());
                    result = result + " ";
                    result = result + taskRef.getProcessId();
                    result = result + " ";
                    result = result + taskRef.getName();
                    result = result + " ";
                    result = result + (taskRef.getDueDate() != null ? AssignedTasksView.this.dateFormat.format(taskRef.getDueDate()) : "");
                    return result;
                }
            });
            this.listBox.setFirstLine("Priority, Process, Task Name, Due Date");
            this.listBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    TaskRef task = AssignedTasksView.this.getSelection();
                    if (task != null) {
                        AssignedTasksView.this.controller.handleEvent(new Event(UpdateDetailsAction.ID, (Object)new DetailViewEvent("AssignedDetailView", task)));
                    }
                }
            });
            VerticalPanel toolBox = new VerticalPanel();
            toolBox.setSpacing(5);
            MenuBar toolBar = new MenuBar();
            toolBar.addItem("Refresh", new Command(){

                public void execute() {
                    AssignedTasksView.this.reload();
                }
            });
            MenuItem viewBtn = new MenuItem("View", new Command(){

                public void execute() {
                    TaskRef selection = AssignedTasksView.this.getSelection();
                    if (selection != null) {
                        if (selection.getUrl() != null && !selection.getUrl().equals("")) {
                            AssignedTasksView.this.iframeWindow = new IFrameWindowPanel(selection.getUrl(), "Task Form: " + selection.getName());
                            AssignedTasksView.this.iframeWindow.setCallback(new IFrameWindowCallback(){

                                public void onWindowClosed() {
                                    AssignedTasksView.this.reload();
                                }
                            });
                            AssignedTasksView.this.iframeWindow.show();
                        } else {
                            Window.alert((String)"Invalid operation. The task doesn't provide a UI");
                        }
                    } else {
                        Window.alert((String)"Missing selection. Please select a task");
                    }
                }
            });
            toolBar.addItem(viewBtn);
            toolBar.addItem("Release", new Command(){

                public void execute() {
                    TaskRef selection = AssignedTasksView.this.getSelection();
                    if (selection != null) {
                        TaskIdentityEvent payload = new TaskIdentityEvent(null, selection);
                        AssignedTasksView.this.controller.handleEvent(new Event(ReleaseTaskAction.ID, (Object)payload));
                    } else {
                        Window.alert((String)"Missing selection. Please select a task");
                    }
                }
            });
            toolBox.add((Widget)toolBar);
            this.taskList.add((Widget)toolBox);
            this.taskList.add((IsWidget)this.listBox);
            this.pagingPanel = new PagingPanel(new PagingCallback(){

                public void rev() {
                    AssignedTasksView.this.renderUpdate();
                }

                public void ffw() {
                    AssignedTasksView.this.renderUpdate();
                }
            });
            this.taskList.add((Widget)this.pagingPanel);
            this.detailsView = new TaskDetailView(false);
            this.controller.addView("AssignedDetailView", (ViewInterface)this.detailsView);
            this.detailsView.initialize();
            this.hasDispatcherPlugin = ServerPlugins.has("org.jboss.bpm.console.server.plugin.FormDispatcherPlugin");
            viewBtn.setEnabled(this.hasDispatcherPlugin);
            ErraiBus.get().subscribe("appContext.model.listener", new MessageCallback(){

                public void callback(Message message) {
                    switch (ModelCommands.valueOf(message.getCommandType())) {
                        case HAS_BEEN_UPDATED: {
                            if (!((String)message.get(String.class, (Enum)ModelParts.CLASS)).equals("processModel")) break;
                            AssignedTasksView.this.reload();
                        }
                    }
                }
            });
            Timer t = new Timer(){

                public void run() {
                    AssignedTasksView.this.reload();
                }
            };
            t.schedule(500);
            this.isInitialized = true;
        }
    }

    private void reload() {
        this.controller.handleEvent(new Event(LoadTasksAction.ID, (Object)this.appContext.getAuthentication().getUsername()));
    }

    public void reset() {
        this.listBox.clear();
        this.controller.handleEvent(new Event(UpdateDetailsAction.ID, (Object)new DetailViewEvent("AssignedDetailView", null)));
    }

    public void update(Object ... data) {
        this.identity = (String)data[0];
        this.cachedTasks = (List)data[1];
        this.pagingPanel.reset();
        this.renderUpdate();
    }

    public void setLoading(boolean isLoading) {
        if (this.panel.isVisible()) {
            LoadingOverlay.on((Widget)this.taskList, isLoading);
        }
    }

    private void renderUpdate() {
        this.initialize();
        this.reset();
        List trimmed = this.pagingPanel.trim(this.cachedTasks);
        for (TaskRef task : trimmed) {
            if (TaskRef.STATE.ASSIGNED != task.getCurrentState()) continue;
            this.listBox.addItem(task);
        }
    }
}

