/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.ActionInterface;
import com.mvc4g.client.Controller;
import com.mvc4g.client.Event;
import com.mvc4g.client.ViewInterface;
import java.util.List;
import org.jboss.bpm.console.client.ApplicationContext;
import org.jboss.bpm.console.client.ClientFactory;
import org.jboss.bpm.console.client.common.CustomizableListBox;
import org.jboss.bpm.console.client.common.DataDriven;
import org.jboss.bpm.console.client.common.LoadingOverlay;
import org.jboss.bpm.console.client.common.ModelCommands;
import org.jboss.bpm.console.client.common.ModelParts;
import org.jboss.bpm.console.client.common.PagingCallback;
import org.jboss.bpm.console.client.common.PagingPanel;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.AbstractTaskList;
import org.jboss.bpm.console.client.task.AssignTaskAction;
import org.jboss.bpm.console.client.task.ClaimTaskAction;
import org.jboss.bpm.console.client.task.LoadTasksAction;
import org.jboss.bpm.console.client.task.LoadTasksParticipationAction;
import org.jboss.bpm.console.client.task.ReleaseTaskAction;
import org.jboss.bpm.console.client.task.ReloadAllTaskListsAction;
import org.jboss.bpm.console.client.task.TaskDetailView;
import org.jboss.bpm.console.client.task.UpdateDetailsAction;
import org.jboss.bpm.console.client.task.events.DetailViewEvent;
import org.jboss.bpm.console.client.task.events.TaskIdentityEvent;
import org.jboss.bpm.console.client.util.SimpleDateFormat;
import org.jboss.errai.bus.client.ErraiBus;
import org.jboss.errai.bus.client.api.Message;
import org.jboss.errai.bus.client.api.MessageCallback;

public class OpenTasksView
extends AbstractTaskList
implements IsWidget,
DataDriven {
    public static final String ID = OpenTasksView.class.getName();
    private TaskDetailView detailsView;
    private final ApplicationContext appContext;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private PagingPanel pagingPanel;
    private DockPanel panel;
    private static boolean actionSetup = false;

    public OpenTasksView(ClientFactory clientFactory) {
        this.appContext = clientFactory.getApplicationContext();
        this.controller = clientFactory.getController();
    }

    public static void registerCommonActions(ApplicationContext applicationContext, Controller controller) {
        if (!actionSetup) {
            controller.addAction(LoadTasksAction.ID, (ActionInterface)new LoadTasksAction(applicationContext));
            controller.addAction(LoadTasksParticipationAction.ID, (ActionInterface)new LoadTasksParticipationAction(applicationContext));
            controller.addAction(ClaimTaskAction.ID, (ActionInterface)new ClaimTaskAction(applicationContext));
            controller.addAction(ReleaseTaskAction.ID, (ActionInterface)new ReleaseTaskAction(applicationContext));
            controller.addAction(UpdateDetailsAction.ID, (ActionInterface)new UpdateDetailsAction());
            controller.addAction(AssignTaskAction.ID, (ActionInterface)new AssignTaskAction(applicationContext));
            controller.addAction(ReloadAllTaskListsAction.ID, (ActionInterface)new ReloadAllTaskListsAction(applicationContext));
            actionSetup = true;
        }
    }

    public Widget asWidget() {
        this.panel = new DockPanel();
        this.initialize();
        OpenTasksView.registerCommonActions(this.appContext, this.controller);
        this.controller.addView(ID, (ViewInterface)this);
        this.panel.add((Widget)this.detailsView, DockPanel.SOUTH);
        this.panel.add((Widget)this.taskList, DockPanel.CENTER);
        return this.panel;
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.taskList = new VerticalPanel();
            this.listBox = new CustomizableListBox<TaskRef>(new CustomizableListBox.ItemFormatter<TaskRef>(){

                @Override
                public String format(TaskRef taskRef) {
                    String result = "";
                    result = result + String.valueOf(taskRef.getPriority());
                    result = result + " ";
                    result = result + taskRef.getProcessId();
                    result = result + " ";
                    result = result + taskRef.getName();
                    result = result + " ";
                    result = result + String.valueOf(taskRef.getCurrentState());
                    result = result + " ";
                    result = result + (taskRef.getDueDate() != null ? OpenTasksView.this.dateFormat.format(taskRef.getDueDate()) : "");
                    return result;
                }
            });
            this.listBox.setFirstLine("Priority, Process, Task Name, Status, Due Date");
            this.listBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    TaskRef task = OpenTasksView.this.getSelection();
                    if (task != null) {
                        OpenTasksView.this.controller.handleEvent(new Event(UpdateDetailsAction.ID, (Object)new DetailViewEvent("OpenDetailView", task)));
                    }
                }
            });
            VerticalPanel toolBox = new VerticalPanel();
            toolBox.setSpacing(5);
            MenuBar toolBar = new MenuBar();
            toolBar.addItem("Refresh", new Command(){

                public void execute() {
                    OpenTasksView.this.reload();
                }
            });
            toolBar.addItem("Claim", new Command(){

                public void execute() {
                    TaskRef selection = OpenTasksView.this.getSelection();
                    if (selection != null) {
                        OpenTasksView.this.controller.handleEvent(new Event(ClaimTaskAction.ID, (Object)new TaskIdentityEvent(OpenTasksView.this.appContext.getAuthentication().getUsername(), selection)));
                    } else {
                        Window.alert((String)"Missing selection. Please select a task");
                    }
                }
            });
            toolBox.add((Widget)toolBar);
            this.taskList.add((Widget)toolBox);
            this.taskList.add((IsWidget)this.listBox);
            this.pagingPanel = new PagingPanel(new PagingCallback(){

                public void rev() {
                    OpenTasksView.this.renderUpdate();
                }

                public void ffw() {
                    OpenTasksView.this.renderUpdate();
                }
            });
            this.taskList.add((Widget)this.pagingPanel);
            this.detailsView = new TaskDetailView(true);
            this.controller.addView("OpenDetailView", (ViewInterface)this.detailsView);
            this.detailsView.initialize();
            ErraiBus.get().subscribe("appContext.model.listener", new MessageCallback(){

                public void callback(Message message) {
                    switch (ModelCommands.valueOf(message.getCommandType())) {
                        case HAS_BEEN_UPDATED: {
                            if (!((String)message.get(String.class, (Enum)ModelParts.CLASS)).equals("processModel")) break;
                            OpenTasksView.this.reload();
                        }
                    }
                }
            });
            Timer t = new Timer(){

                public void run() {
                    OpenTasksView.this.reload();
                }
            };
            t.schedule(500);
            this.isInitialized = true;
        }
    }

    private void reload() {
        this.controller.handleEvent(new Event(LoadTasksParticipationAction.ID, (Object)this.getAssignedIdentity()));
    }

    public void reset() {
        this.listBox.clear();
        this.controller.handleEvent(new Event(UpdateDetailsAction.ID, (Object)new DetailViewEvent("OpenDetailView", null)));
    }

    public void update(Object ... data) {
        this.identity = (String)data[0];
        this.cachedTasks = (List)data[1];
        this.pagingPanel.reset();
        this.renderUpdate();
    }

    public void setLoading(boolean isLoading) {
        if (this.panel.isVisible()) {
            LoadingOverlay.on((Widget)this.taskList, isLoading);
        }
    }

    private void renderUpdate() {
        this.initialize();
        this.reset();
        List trimmed = this.pagingPanel.trim(this.cachedTasks);
        for (TaskRef task : trimmed) {
            if (TaskRef.STATE.OPEN != task.getCurrentState()) continue;
            this.listBox.addItem(task);
        }
    }
}

