/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.client.task;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.mvc4g.client.Controller;
import com.mvc4g.client.ViewInterface;
import org.jboss.bpm.console.client.LazyPanel;
import org.jboss.bpm.console.client.common.PropertyGrid;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.task.ParticipantPanel;

public class TaskDetailView
extends SimplePanel
implements ViewInterface,
LazyPanel {
    public static final String ID = TaskDetailView.class.getName();
    private Controller controller;
    private TaskRef currentTask = null;
    private PropertyGrid grid;
    private ParticipantPanel participantPanel;
    private boolean openView;
    private boolean initialzed;

    public TaskDetailView(boolean openView) {
        super.setStyleName("bpm-detail-panel");
        this.openView = openView;
    }

    public boolean isInitialized() {
        return this.initialzed;
    }

    public void initialize() {
        if (!this.initialzed) {
            this.grid = new PropertyGrid(new String[]{"ID:", "Process:", "Name:", "Assignee:", "Description:"});
            if (this.openView) {
                final DeckPanel deck = new DeckPanel();
                deck.add((Widget)this.grid);
                this.participantPanel = new ParticipantPanel();
                this.participantPanel.setController(this.controller);
                final ListBox dropBox = new ListBox(false);
                dropBox.setStyleName("bpm-operation-ui");
                dropBox.addItem("Properties");
                dropBox.addItem("Participants");
                dropBox.addChangeListener(new ChangeListener(){

                    public void onChange(Widget sender) {
                        deck.showWidget(dropBox.getSelectedIndex());
                    }
                });
                deck.add((Widget)this.participantPanel);
                this.add((Widget)deck);
                deck.showWidget(dropBox.getSelectedIndex());
            } else {
                SimplePanel p = new SimplePanel();
                p.add((Widget)this.grid);
                this.add((Widget)p);
            }
            this.initialzed = true;
        }
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void update(TaskRef task) {
        String description = task.getDescription() != null ? task.getDescription() : "";
        String[] values = new String[]{String.valueOf(task.getId()), task.getProcessId(), task.getName(), task.getAssignee(), description};
        this.grid.update(values);
        if (this.openView && this.participantPanel != null) {
            this.participantPanel.update(task);
        }
    }

    public void clearView() {
        this.grid.clear();
        if (this.openView && this.participantPanel != null) {
            this.participantPanel.clearView();
        }
        this.currentTask = null;
    }
}

