/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.monitor.gui.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.UUID;
import org.jboss.bpm.monitor.gui.client.ChartData;
import org.jboss.bpm.monitor.model.BPAFDataSource;
import org.jboss.bpm.monitor.model.DataSourceFactory;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.bpaf.State;
import org.jboss.bpm.monitor.model.json.XYDataSetJSO;
import org.jboss.bpm.monitor.model.metric.Grouping;
import org.jboss.bpm.monitor.model.metric.Timespan;
import org.jboss.bpm.monitor.model.metric.TimespanFactory;
import org.jboss.errai.bus.server.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ChartDataService
implements ChartData {
    private BPAFDataSource dataSource = DataSourceFactory.createDataSource();

    @Override
    public String getCompletedInstances(String processDefiniton, String timespanValue) {
        this.assertDataSource();
        Timespan timespan = TimespanFactory.fromValue((String)timespanValue);
        List events = this.dataSource.getInstanceEvents(processDefiniton, timespan, State.Closed_Completed);
        return ChartDataService.createDatasetJSO(new String[]{"Completed"}, timespan, true, events);
    }

    @Override
    public String getFailedInstances(String processDefiniton, String timespanValue) {
        this.assertDataSource();
        Timespan timespan = TimespanFactory.fromValue((String)timespanValue);
        List completed = this.dataSource.getInstanceEvents(processDefiniton, timespan, State.Closed_Completed);
        List failed = this.dataSource.getInstanceEvents(processDefiniton, timespan, State.Closed_Completed_Failed);
        List terminated = this.dataSource.getInstanceEvents(processDefiniton, timespan, State.Closed_Cancelled_Terminated);
        return ChartDataService.createDatasetJSO(new String[]{"Completed", "Failed", "Terminated"}, timespan, true, completed, failed, terminated);
    }

    private static String createDatasetJSO(String[] title, Timespan timespan, boolean matchParity, List<Event> ... events) {
        XYDataSetJSO dataSet = new XYDataSetJSO(title, UUID.randomUUID().toString());
        for (List<Event> subset : events) {
            SortedMap<Date, List<Event>> grouped = ChartDataService.group(timespan, subset);
            ArrayList<Long> domainData = new ArrayList<Long>(grouped.size());
            ArrayList<Long> rangeData = new ArrayList<Long>(grouped.size());
            for (Date d : grouped.keySet()) {
                domainData.add(d.getTime());
                int actualSize = matchParity ? ((List)grouped.get(d)).size() / 2 : ((List)grouped.get(d)).size();
                rangeData.add(new Integer(actualSize).longValue());
            }
            dataSet.getDomain().add(domainData);
            dataSet.getRange().add(rangeData);
        }
        dataSet.setAxis("date");
        return dataSet.toJSO();
    }

    private static SortedMap<Date, List<Event>> group(Timespan timespan, List<Event> events) {
        SortedMap grouped;
        switch (timespan.getUnit()) {
            case HOUR: {
                grouped = Grouping.byHour(events, (Timespan)timespan);
                break;
            }
            case DAY: {
                grouped = Grouping.byDay(events, (Timespan)timespan);
                break;
            }
            case WEEK: {
                grouped = Grouping.byWeek(events, (Timespan)timespan);
                break;
            }
            case MONTH: {
                grouped = Grouping.byMonth(events, (Timespan)timespan);
                break;
            }
            default: {
                throw new IllegalArgumentException("UNIT not supported: " + timespan.getUnit());
            }
        }
        return grouped;
    }

    private void assertDataSource() {
        if (null == this.dataSource) {
            throw new IllegalStateException("BPAFDataSource not initialized");
        }
    }
}

