/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.yesmail.gwt.rolodex.client;

import com.google.gwt.resources.client.ClientBundle;

/**
 * Implement/extend this interface to create your own card bundle.
 * Method names for new cards must return a RolodexCard and must either be
 * named like its image file or a @ClientBundle.Source annotation specifying the exact file
 * name must be used.
 *
 * @see ClientBundle for more details on creating these types of methods
 */
public interface RolodexCardBundle extends ClientBundle {

  /**
   * Implementations of this method will be overridden by the generated method.
   *
   * @return Max height for the rolodex widget
   */
  int getMaxHeight();

  /**
   * If the getRolodexCards method is not implemented, then one will be generated
   * that gives all cards in alphabetical order (NOT the method order in the source file).
   *
   * @return An ordered list of cards to be used within the rolodex widget
   */
  RolodexCard[] getRolodexCards();
}
