/*******************************************************************************
 *  Copyright 2001, 2007 JamesLuo(JamesLuo.au@gmail.com)
 *  
 *  Licensed under the Apache License, Version 2.0 (the "License"); you may not
 *  use this file except in compliance with the License. You may obtain a copy of
 *  the License at
 *  
 *  http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  License for the specific language governing permissions and limitations under
 *  the License.
 * 
 *  Contributors:
 *******************************************************************************/


package com.gwtent.reflection.client.impl;

import com.gwtent.reflection.client.ClassType;
import com.gwtent.reflection.client.Constructor;
import com.gwtent.reflection.client.Method;



public abstract class ConstructorImpl<T> extends AbstractMethodImpl implements Constructor<T> {
	  private final ClassType<T> enclosingType;

	  public ConstructorImpl(ClassTypeImpl<T> enclosingType) {
	    super(enclosingType.getName() + ".Constructor");
	    this.enclosingType = enclosingType;
	    enclosingType.addConstructor(this);
	  }

	  public ClassType<T> getEnclosingType() {
	    return enclosingType;
	  }

	  public String getReadableDeclaration() {
	    String[] names = TypeOracleImpl.modifierBitsToNames(getModifierBits());
	    StringBuffer sb = new StringBuffer();
	    for (int i = 0; i < names.length; i++) {
	      sb.append(names[i]);
	      sb.append(" ");
	    }
//	    if (getTypeParameters().length > 0) {
//	      toStringTypeParams(sb);
//	      sb.append(" ");
//	    }
	    sb.append(getName());
	    toStringParamsAndThrows(sb);
	    return sb.toString();
	  }

	  public Constructor<T> isConstructor() {
	    return this;
	  }

	  public Method isMethod() {
	    return null;
	  }

	  public String toString() {
	    return getReadableDeclaration();
	  }

		public Class<T> getDeclaringClass() {
			return this.getEnclosingType().getDeclaringClass();
		}

		public int getModifiers() {
			return this.getModifierBits();
		}
	}
