/*
 * Copyright 2010 JBoss, a divison Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.errai.bus.server;

/**
 * <tt>ErraiBootstrapFailure</tt> extends the <tt>RuntimeException</tt>. It is thrown when configurations and/or
 * initializations of the server fail
 */
public class ErraiBootstrapFailure extends RuntimeException {

  public ErraiBootstrapFailure() {
    super();
  }

  public ErraiBootstrapFailure(String message) {
    super(message);
  }

  public ErraiBootstrapFailure(String message, Throwable cause) {
    super(message, cause);
  }

  public ErraiBootstrapFailure(Throwable cause) {
    super(cause);
  }
}
