/*
 * Copyright 2008 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.timepedia.chronoscope.client.browser.theme.chrome;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.StyleInjector;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.user.client.ui.ImageBundle;

import org.timepedia.chronoscope.client.browser.theme.Theme;

public class ThemeStyleInjector  {

  /**
   * Resources used.
   */
  public interface Resources extends ClientBundle {
    // Resources INSTANCE = GWT.create(Resources.class);

    @Source("corner.png")
    DataResource corner();

    @Source("hborder.png")
    DataResource hborder();
    
    @Source("vborder.png")
    DataResource vborder();
    
    @Source("chrome.css")
    CssResource css();
    
   
   
  }

  /**
   * This is the worlds simplest.
   * @param theme
   */
  public static void injectTheme(Theme theme) {
    switch(theme) {
      case NONE:
        break;
      case DARK:
      case STANDARD:
      case CHROME:
      default:
      // StyleInjector.injectStylesheet(Resources.INSTANCE.css().getText());
    }
  }
}
