/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.journal.CorruptedTransactionLogException;
import bitronix.tm.journal.Journal;
import bitronix.tm.journal.TransactionLogAppender;
import bitronix.tm.journal.TransactionLogCursor;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.Uid;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskJournal
implements Journal {
    private static final Logger log = LoggerFactory.getLogger(DiskJournal.class);
    private TransactionLogAppender activeTla;
    private TransactionLogAppender tla1;
    private TransactionLogAppender tla2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int status, Uid gtrid, Set uniqueNames) throws IOException {
        if (this.activeTla == null) {
            throw new IOException("cannot write log, disk logger is not open");
        }
        if (TransactionManagerServices.getConfiguration().isFilterLogStatus() && status != 8 && status != 3 && status != 5) {
            if (log.isDebugEnabled()) {
                log.debug("filtered out write to log for status " + Decoder.decodeStatus(status));
            }
            return;
        }
        DiskJournal diskJournal = this;
        synchronized (diskJournal) {
            TransactionLogRecord tlog = new TransactionLogRecord(status, gtrid, uniqueNames);
            boolean written = this.activeTla.writeLog(tlog);
            if (!written) {
                this.swapJournalFiles();
                written = this.activeTla.writeLog(tlog);
                if (!written) {
                    throw new IOException("no room to write log to journal even after swap, circular collision avoided");
                }
            }
        }
    }

    public void force() throws IOException {
        if (this.activeTla == null) {
            throw new IOException("cannot force log writing, disk logger is not open");
        }
        this.activeTla.force();
    }

    public synchronized void open() throws IOException {
        if (this.activeTla != null) {
            log.warn("disk journal already open");
            return;
        }
        File file1 = new File(TransactionManagerServices.getConfiguration().getLogPart1Filename());
        File file2 = new File(TransactionManagerServices.getConfiguration().getLogPart2Filename());
        if (!file1.exists() && !file2.exists()) {
            log.debug("creation of log files");
            DiskJournal.createLogfile(file2, TransactionManagerServices.getConfiguration().getMaxLogSizeInMb());
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            DiskJournal.createLogfile(file1, TransactionManagerServices.getConfiguration().getMaxLogSizeInMb());
        }
        if (file1.length() != file2.length()) {
            if (!TransactionManagerServices.getConfiguration().isSkipCorruptedLogs()) {
                throw new IOException("transaction log files are not of the same length, assuming they're corrupt");
            }
            log.error("transaction log files are not of the same length: corrupted files?");
        }
        long maxFileLength = Math.max(file1.length(), file2.length());
        if (log.isDebugEnabled()) {
            log.debug("disk journal files max length: " + maxFileLength);
        }
        this.tla1 = new TransactionLogAppender(file1, maxFileLength);
        this.tla2 = new TransactionLogAppender(file2, maxFileLength);
        byte cleanStatus = this.pickActiveJournalFile(this.tla1, this.tla2);
        if (cleanStatus != 0) {
            log.warn("active log file is unclean, did you call BitronixTransactionManager.shutdown() at the end of the last run?");
        }
        if (log.isDebugEnabled()) {
            log.debug("disk journal opened");
        }
    }

    public synchronized void close() throws IOException {
        if (this.activeTla == null) {
            return;
        }
        try {
            this.tla1.close();
        }
        catch (IOException ex) {
            log.error("cannot close " + this.tla1, (Throwable)ex);
        }
        this.tla1 = null;
        try {
            this.tla2.close();
        }
        catch (IOException ex) {
            log.error("cannot close " + this.tla2, (Throwable)ex);
        }
        this.tla2 = null;
        this.activeTla = null;
        log.debug("disk journal closed");
    }

    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException ex) {
            log.error("error shutting down disk journal. Transaction log integrity could be compromised!", (Throwable)ex);
        }
    }

    public Map collectDanglingRecords() throws IOException {
        if (this.activeTla == null) {
            throw new IOException("cannot collect dangling records, disk logger is not open");
        }
        return DiskJournal.collectDanglingRecords(this.activeTla);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createLogfile(File logfile, int maxLogSizeInMb) throws IOException {
        boolean deleted;
        if (logfile.isDirectory()) {
            throw new IOException("log file is referring to a directory: " + logfile.getAbsolutePath());
        }
        if (logfile.exists() && !(deleted = logfile.delete())) {
            throw new IOException("log file exists but cannot be overwritten: " + logfile.getAbsolutePath());
        }
        if (logfile.getParentFile() != null) {
            logfile.getParentFile().mkdirs();
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(logfile, "rw");
            raf.seek(0L);
            raf.writeInt(1114926712);
            raf.writeLong(System.currentTimeMillis());
            raf.writeByte(0);
            raf.writeLong(21L);
            byte[] buffer = new byte[4096];
            int length = maxLogSizeInMb * 1024 * 1024 / 4096;
            for (int i = 0; i < length; ++i) {
                raf.write(buffer);
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    private byte pickActiveJournalFile(TransactionLogAppender tla1, TransactionLogAppender tla2) throws IOException {
        if (tla1.getHeader().getTimestamp() > tla2.getHeader().getTimestamp()) {
            this.activeTla = tla1;
            if (log.isDebugEnabled()) {
                log.debug("logging to file 1: " + this.activeTla);
            }
        } else {
            this.activeTla = tla2;
            if (log.isDebugEnabled()) {
                log.debug("logging to file 2: " + this.activeTla);
            }
        }
        byte cleanState = this.activeTla.getHeader().getState();
        this.activeTla.getHeader().setState((byte)-1);
        if (log.isDebugEnabled()) {
            log.debug("log file activated, forcing file state to disk");
        }
        this.activeTla.force();
        return cleanState;
    }

    private void swapJournalFiles() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("swapping journal log file to " + this.getPassiveTransactionLogAppender());
        }
        TransactionLogAppender passiveTla = this.getPassiveTransactionLogAppender();
        passiveTla.getHeader().rewind();
        DiskJournal.copyDanglingRecords(this.activeTla, passiveTla);
        passiveTla.getHeader().setTimestamp(System.currentTimeMillis());
        passiveTla.force();
        this.activeTla = this.activeTla == this.tla1 ? this.tla2 : this.tla1;
        if (log.isDebugEnabled()) {
            log.debug("journal log files swapped");
        }
    }

    private TransactionLogAppender getPassiveTransactionLogAppender() {
        if (this.tla1 == this.activeTla) {
            return this.tla2;
        }
        return this.tla1;
    }

    private static void copyDanglingRecords(TransactionLogAppender fromTla, TransactionLogAppender toTla) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("starting copy of dangling records");
        }
        Map danglingRecords = DiskJournal.collectDanglingRecords(fromTla);
        for (TransactionLogRecord tlog : danglingRecords.values()) {
            toTla.writeLog(tlog);
        }
        if (log.isDebugEnabled()) {
            log.debug(danglingRecords.size() + " dangling record(s) copied to passive log file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map collectDanglingRecords(TransactionLogAppender tla) throws IOException {
        HashMap<Uid, TransactionLogRecord> danglingRecords = new HashMap<Uid, TransactionLogRecord>(64);
        TransactionLogCursor tlc = tla.getCursor();
        try {
            int committing = 0;
            int committed = 0;
            while (true) {
                TransactionLogRecord rec;
                TransactionLogRecord tlog;
                try {
                    tlog = tlc.readLog();
                }
                catch (CorruptedTransactionLogException ex) {
                    if (TransactionManagerServices.getConfiguration().isSkipCorruptedLogs()) {
                        log.error("skipping corrupted log", (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
                if (tlog == null) break;
                if (tlog.getStatus() == 8) {
                    danglingRecords.put(tlog.getGtrid(), tlog);
                    ++committing;
                }
                if (tlog.getStatus() != 3 || (rec = (TransactionLogRecord)danglingRecords.get(tlog.getGtrid())) == null) continue;
                rec.removeUniqueNames(tlog.getUniqueNames());
                if (!rec.getUniqueNames().isEmpty()) continue;
                danglingRecords.remove(tlog.getGtrid());
                ++committed;
            }
            if (log.isDebugEnabled()) {
                log.debug("collected dangling records of " + tla + ", committing: " + committing + ", committed: " + committed + ", delta: " + danglingRecords.size());
            }
        }
        finally {
            tlc.close();
        }
        return danglingRecords;
    }
}

