/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.List;
import java.util.Map;
import org.drools.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.ConstraintTrigger;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StartEventHandler
extends AbstractNodeHandler {
    protected Node createNode(Attributes attrs) {
        return new StartNode();
    }

    public Class generateNodeFor() {
        return StartNode.class;
    }

    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StartNode startNode = (StartNode)node;
        block0: for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, startNode);
                continue;
            }
            if ("conditionalEventDefinition".equals(nodeName)) {
                String constraint = null;
                for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                    String subnodeName = subNode.getNodeName();
                    if (!"condition".equals(subnodeName)) continue;
                    constraint = xmlNode.getTextContent();
                    break;
                }
                ConstraintTrigger trigger = new ConstraintTrigger();
                trigger.setConstraint(constraint);
                startNode.addTrigger((Trigger)trigger);
                break;
            }
            if ("signalEventDefinition".equals(nodeName)) {
                String type = ((Element)xmlNode).getAttribute("signalRef");
                if (type == null || type.trim().length() <= 0) continue;
                EventTrigger trigger = new EventTrigger();
                EventTypeFilter eventFilter = new EventTypeFilter();
                eventFilter.setType(type);
                trigger.addEventFilter((EventFilter)eventFilter);
                String mapping = (String)startNode.getMetaData("TriggerMapping");
                if (mapping != null) {
                    trigger.addInMapping(mapping, "event");
                }
                startNode.addTrigger((Trigger)trigger);
                continue;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                String messageRef = ((Element)xmlNode).getAttribute("messageRef");
                Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
                if (messages == null) {
                    throw new IllegalArgumentException("No messages found");
                }
                Message message = (Message)messages.get(messageRef);
                if (message == null) {
                    throw new IllegalArgumentException("Could not find message " + messageRef);
                }
                startNode.setMetaData("MessageType", (Object)message.getType());
                EventTrigger trigger = new EventTrigger();
                EventTypeFilter eventFilter = new EventTypeFilter();
                eventFilter.setType("Message-" + messageRef);
                trigger.addEventFilter((EventFilter)eventFilter);
                String mapping = (String)startNode.getMetaData("TriggerMapping");
                if (mapping != null) {
                    trigger.addInMapping(mapping, "event");
                }
                startNode.addTrigger((Trigger)trigger);
                continue;
            }
            if (!"timerEventDefinition".equals(nodeName)) continue;
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String subNodeName = subNode.getNodeName();
                if ("timeCycle".equals(subNodeName)) {
                    String period = subNode.getTextContent();
                    String language = ((Element)subNode).getAttribute("language");
                    if (language == null || language.trim().length() == 0) {
                        language = "int";
                    }
                    if (period != null && period.trim().length() > 0) {
                        ConstraintTrigger trigger = new ConstraintTrigger();
                        trigger.setConstraint("");
                        if ("int".equals(language)) {
                            trigger.setHeader("timer (int:" + period + " " + period + ")");
                        } else {
                            trigger.setHeader("timer (" + language + ":" + period + ")");
                        }
                        startNode.addTrigger((Trigger)trigger);
                        continue block0;
                    }
                }
                subNode = subNode.getNextSibling();
            }
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, StartNode startNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            subNode = subNode.getNextSibling();
        }
        String to = subNode.getTextContent();
        startNode.setMetaData("TriggerMapping", (Object)to);
    }

    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        StartNode startNode = (StartNode)node;
        this.writeNode("startEvent", (Node)startNode, xmlDump, metaDataType);
        List triggers = startNode.getTriggers();
        if (triggers != null) {
            xmlDump.append(">" + EOL);
            if (triggers.size() > 1) {
                throw new IllegalArgumentException("Multiple start triggers not supported");
            }
            Trigger trigger = (Trigger)triggers.get(0);
            if (trigger instanceof ConstraintTrigger) {
                ConstraintTrigger constraintTrigger = (ConstraintTrigger)trigger;
                if (constraintTrigger.getHeader() == null) {
                    xmlDump.append("      <conditionalEventDefinition>" + EOL);
                    xmlDump.append("        <condition xsi:type=\"tFormalExpression\" language=\"http://www.jboss.org/drools/rule\">" + constraintTrigger.getConstraint() + "</condition>" + EOL);
                    xmlDump.append("      </conditionalEventDefinition>" + EOL);
                } else {
                    String header = constraintTrigger.getHeader();
                    header = header.substring(7, header.length() - 1);
                    int index = header.indexOf(":");
                    String language = header.substring(0, index);
                    header = header.substring(index + 1);
                    String cycle = null;
                    if ("int".equals(language)) {
                        int lenght = (header.length() - 1) / 2;
                        cycle = header.substring(0, lenght);
                    } else {
                        cycle = header;
                    }
                    xmlDump.append("      <timerEventDefinition>" + EOL);
                    xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\" language=\"" + language + "\">" + cycle + "</timeCycle>" + EOL);
                    xmlDump.append("      </timerEventDefinition>" + EOL);
                }
            } else if (trigger instanceof EventTrigger) {
                String type;
                EventTrigger eventTrigger = (EventTrigger)trigger;
                if (!trigger.getInMappings().isEmpty()) {
                    String mapping = (String)eventTrigger.getInMappings().keySet().iterator().next();
                    xmlDump.append("      <dataOutput id=\"_" + startNode.getId() + "_Output\" />" + EOL + "      <dataOutputAssociation>" + EOL + "        <sourceRef>_" + startNode.getId() + "_Output</sourceRef>" + EOL + "        <targetRef>" + mapping + "</targetRef>" + EOL + "      </dataOutputAssociation>" + EOL + "      <outputSet>" + EOL + "        <dataOutputRefs>_" + startNode.getId() + "_Output</dataOutputRefs>" + EOL + "      </outputSet>" + EOL);
                }
                if ((type = ((EventTypeFilter)eventTrigger.getEventFilters().get(0)).getType()).startsWith("Message-")) {
                    type = type.substring(8);
                    xmlDump.append("      <messageEventDefinition messageRef=\"" + type + "\"/>" + EOL);
                } else {
                    xmlDump.append("      <signalEventDefinition signalRef=\"" + type + "\" />" + EOL);
                }
            } else {
                throw new IllegalArgumentException("Unsupported trigger type " + trigger);
            }
            this.endNode("startEvent", xmlDump);
        } else {
            this.endNode(xmlDump);
        }
    }
}

