/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.drools.base.EvaluatorWrapper;
import org.drools.base.evaluators.Operator;
import org.drools.compiler.DrlExprParser;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.lang.ExpressionRewriter;
import org.drools.lang.descr.AtomicExprDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.OperatorDescr;
import org.drools.lang.descr.RelationalExprDescr;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.DialectUtil;
import org.drools.util.CompositeClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELDumper
extends ReflectiveVisitor
implements ExpressionRewriter {
    private static final Pattern evalRegexp = Pattern.compile("^eval\\s*\\(", 8);
    private static final String[] standard = new String[]{"==", "<", ">", ">=", "<=", "!=", "~=", "instanceof"};

    @Override
    public String dump(BaseDescr base) {
        return this.dump(new StringBuilder(), base, 0, false, this.createContext()).toString();
    }

    @Override
    public String dump(BaseDescr base, MVELDumperContext context) {
        return this.dump(new StringBuilder(), base, 0, false, context).toString();
    }

    @Override
    public String dump(BaseDescr base, int parentPrecedence) {
        return this.dump(new StringBuilder(), base, parentPrecedence, false, this.createContext()).toString();
    }

    @Override
    public StringBuilder dump(StringBuilder sbuilder, BaseDescr base, int parentPriority, boolean isInsideRelCons, MVELDumperContext context) {
        if (context == null) {
            context = this.createContext();
        }
        if (base instanceof ConstraintConnectiveDescr) {
            this.processConnectiveDescr(sbuilder, base, parentPriority, isInsideRelCons, context);
        } else if (base instanceof AtomicExprDescr) {
            AtomicExprDescr atomicExpr = (AtomicExprDescr)base;
            String expr = atomicExpr.getExpression().trim();
            String[] instanceofAndCastedExpr = this.processInlineCast(expr = this.processEval(expr), atomicExpr, context);
            expr = instanceofAndCastedExpr != null ? instanceofAndCastedExpr[0] + instanceofAndCastedExpr[1] : this.processInferredCast(expr, atomicExpr, context);
            sbuilder.append(expr);
        } else if (base instanceof BindingDescr) {
            context.addBinding((BindingDescr)base);
            if (isInsideRelCons) {
                BindingDescr bind = (BindingDescr)base;
                String expr = bind.getExpression().trim();
                sbuilder.append(expr);
            }
        } else if (base instanceof RelationalExprDescr) {
            RelationalExprDescr red = (RelationalExprDescr)base;
            StringBuilder left = this.dump(new StringBuilder(), red.getLeft(), Integer.MAX_VALUE, true, context);
            StringBuilder right = red.getRight() instanceof AtomicExprDescr ? this.processRightAtomicExpr(left, (AtomicExprDescr)red.getRight(), context) : this.dump(new StringBuilder(), red.getRight(), Integer.MAX_VALUE, true, context);
            this.processRestriction(context, sbuilder, left.toString(), red.getOperatorDescr(), right.toString());
        } else if (base instanceof ExprConstraintDescr) {
            DrlExprParser expr = new DrlExprParser();
            ConstraintConnectiveDescr result = expr.parse(((ExprConstraintDescr)base).getExpression());
            if (result.getDescrs().size() == 1) {
                this.dump(sbuilder, result.getDescrs().get(0), 0, isInsideRelCons, context);
            } else {
                this.dump(sbuilder, result, 0, isInsideRelCons, context);
            }
        }
        return sbuilder;
    }

    private StringBuilder processRightAtomicExpr(StringBuilder left, AtomicExprDescr atomicExpr, MVELDumperContext context) {
        String expr = atomicExpr.getExpression().trim();
        String[] instanceofAndCastedExpr = this.processInlineCast(expr = this.processEval(expr), atomicExpr, context);
        if (instanceofAndCastedExpr != null) {
            expr = instanceofAndCastedExpr[1];
            left.insert(0, instanceofAndCastedExpr[0]);
        }
        return new StringBuilder(expr);
    }

    String[] processInlineCast(String expr, AtomicExprDescr atomicExpr, MVELDumperContext context) {
        int sharpPos = expr.indexOf(35);
        if (sharpPos < 0) {
            return null;
        }
        String field1 = expr.substring(0, sharpPos).trim();
        int sharpPos2 = expr.indexOf(35, sharpPos + 1);
        String part2 = sharpPos2 < 0 ? expr.substring(sharpPos + 1).trim() : expr.substring(sharpPos + 1, sharpPos2).trim();
        String[] classAndField = this.splitInClassAndField(part2, context);
        if (classAndField == null) {
            return null;
        }
        String className = classAndField[0];
        String field2 = classAndField[1];
        String castedExpression = "((" + className + ")" + field1 + ")." + field2;
        String instanceofExpression = "";
        if (sharpPos2 >= 0) {
            String[] instanceofAndCastedExpr = this.processInlineCast(castedExpression + expr.substring(sharpPos2), atomicExpr, context);
            if (instanceofAndCastedExpr == null) {
                return null;
            }
            instanceofExpression = instanceofAndCastedExpr[0];
            castedExpression = instanceofAndCastedExpr[1];
        }
        atomicExpr.setRewrittenExpression(castedExpression);
        instanceofExpression = field1 + " instanceof " + className + " && " + instanceofExpression;
        return new String[]{instanceofExpression, castedExpression};
    }

    private String processInferredCast(String expr, AtomicExprDescr atomicExpr, MVELDumperContext context) {
        Map.Entry<String, String> castEntry = context.getInferredCast(expr);
        if (castEntry == null) {
            return expr;
        }
        String castedExpr = "((" + castEntry.getValue() + ")" + castEntry.getKey() + ")" + expr.substring(castEntry.getKey().length());
        atomicExpr.setRewrittenExpression(castedExpr);
        return castedExpr;
    }

    private String processEval(String expr) {
        return evalRegexp.matcher(expr).find() ? expr.substring(expr.indexOf(40) + 1, expr.lastIndexOf(41)) : expr;
    }

    private String[] splitInClassAndField(String expr, MVELDumperContext context) {
        String[] split = expr.split("\\.");
        if (split.length < 3) {
            return split.length == 2 ? split : null;
        }
        RuleBuildContext ruleContext = context.getRuleContext();
        if (DialectUtil.findClassByName(ruleContext, split[0]) != null) {
            return new String[]{split[0], this.concatDotSeparated(split, 1, split.length)};
        }
        CompositeClassLoader cl = ruleContext.getPackageBuilder().getRootClassLoader();
        for (int i = split.length - 1; i > 1; ++i) {
            String className = this.concatDotSeparated(split, 0, i);
            if (ClassUtils.findClass((String)className, (ClassLoader)cl) == null) continue;
            return new String[]{className, this.concatDotSeparated(split, i, split.length)};
        }
        return null;
    }

    private String concatDotSeparated(String[] parts, int start, int end) {
        StringBuilder sb = new StringBuilder(parts[start]);
        for (int i = start + 1; i < end; ++i) {
            sb.append(".").append(parts[i]);
        }
        return sb.toString();
    }

    protected void processConnectiveDescr(StringBuilder sbuilder, BaseDescr base, int parentPriority, boolean isInsideRelCons, MVELDumperContext context) {
        boolean wrapParenthesis;
        ConstraintConnectiveDescr ccd = (ConstraintConnectiveDescr)base;
        boolean first = true;
        boolean bl = wrapParenthesis = parentPriority > ccd.getConnective().getPrecedence();
        if (wrapParenthesis) {
            sbuilder.append("( ");
        }
        for (BaseDescr constr : ccd.getDescrs()) {
            if (!(constr instanceof BindingDescr)) {
                if (first) {
                    first = false;
                } else {
                    sbuilder.append(" ");
                    sbuilder.append(ccd.getConnective().toString());
                    sbuilder.append(" ");
                }
            }
            this.dump(sbuilder, constr, ccd.getConnective().getPrecedence(), isInsideRelCons, context);
        }
        if (first) {
            sbuilder.append("true");
        }
        if (wrapParenthesis) {
            sbuilder.append(" )");
        }
    }

    @Override
    public void processRestriction(MVELDumperContext context, StringBuilder sbuilder, String left, OperatorDescr operator, String right) {
        Operator op = Operator.determineOperator((String)operator.getOperator(), (boolean)operator.isNegated());
        if (op == Operator.determineOperator((String)"memberOf", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(right).append(" contains ").append(left).append(this.evaluatorSufix(operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"contains", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" contains ").append(right).append(this.evaluatorSufix(operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"excludes", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(!operator.isNegated())).append(left).append(" contains ").append(right).append(this.evaluatorSufix(!operator.isNegated()));
        } else if (op == Operator.determineOperator((String)"matches", (boolean)operator.isNegated())) {
            sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" ~= ").append(right).append(this.evaluatorSufix(operator.isNegated()));
        } else if (this.lookupBasicOperator(operator.getOperator())) {
            if (operator.getOperator().equals("instanceof")) {
                context.addInferredCast(left, right);
            }
            this.rewriteBasicOperator(context, sbuilder, left, operator, right);
        } else {
            this.rewriteOperator(context, sbuilder, left, operator, right);
        }
    }

    protected void rewriteBasicOperator(MVELDumperContext context, StringBuilder sbuilder, String left, OperatorDescr operator, String right) {
        sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(left).append(" ").append(operator.getOperator()).append(" ").append(right).append(this.evaluatorSufix(operator.isNegated()));
    }

    protected boolean lookupBasicOperator(String op) {
        return Arrays.binarySearch(standard, op) >= 0;
    }

    protected void rewriteOperator(MVELDumperContext context, StringBuilder sbuilder, String left, OperatorDescr operator, String right) {
        String alias = context.createAlias(operator);
        operator.setLeftString(left);
        operator.setRightString(right);
        sbuilder.append(this.evaluatorPrefix(operator.isNegated())).append(alias).append(".evaluate( ").append(left).append(", ").append(right).append(" )").append(this.evaluatorSufix(operator.isNegated()));
    }

    protected String evaluatorPrefix(boolean isNegated) {
        if (isNegated) {
            return "!( ";
        }
        return "";
    }

    protected String evaluatorSufix(boolean isNegated) {
        if (isNegated) {
            return " )";
        }
        return "";
    }

    protected MVELDumperContext createContext() {
        return new MVELDumperContext();
    }

    @Override
    public Class<?> getEvaluatorWrapperClass() {
        return EvaluatorWrapper.class;
    }

    static {
        Arrays.sort(standard);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MVELDumperContext {
        protected Map<String, OperatorDescr> aliases = new HashMap<String, OperatorDescr>();
        protected int counter = 0;
        protected List<BindingDescr> bindings = null;
        protected Map<String, Class<?>> localTypes = null;
        private RuleBuildContext ruleContext;
        private Map<String, String> inferredCasts;

        public void clear() {
            this.aliases.clear();
            this.counter = 0;
            this.bindings = null;
            this.localTypes = null;
        }

        public void addInferredCast(String var, String cast) {
            if (this.inferredCasts == null) {
                this.inferredCasts = new HashMap<String, String>();
            }
            this.inferredCasts.put(var, cast);
        }

        public Map.Entry<String, String> getInferredCast(String expr) {
            if (this.inferredCasts != null) {
                for (Map.Entry<String, String> entry : this.inferredCasts.entrySet()) {
                    if (!expr.matches(entry.getKey() + "\\s*\\..+")) continue;
                    return entry;
                }
            }
            return null;
        }

        public Map<String, OperatorDescr> getAliases() {
            return this.aliases;
        }

        public void setAliases(Map<String, OperatorDescr> aliases) {
            this.aliases = aliases;
        }

        public String createAlias(OperatorDescr operator) {
            String alias = operator.getOperator() + this.counter++;
            operator.setAlias(alias);
            this.aliases.put(alias, operator);
            return alias;
        }

        public void addBinding(BindingDescr bind) {
            if (this.bindings == null) {
                this.bindings = new ArrayList<BindingDescr>();
            }
            this.bindings.add(bind);
        }

        public List<BindingDescr> getBindings() {
            return this.bindings == null ? Collections.EMPTY_LIST : this.bindings;
        }

        public Map<String, Class<?>> getLocalTypes() {
            return this.localTypes;
        }

        public void setLocalTypes(Map<String, Class<?>> localTypes) {
            this.localTypes = localTypes;
        }

        public RuleBuildContext getRuleContext() {
            return this.ruleContext;
        }

        public MVELDumperContext setRuleContext(RuleBuildContext ruleContext) {
            this.ruleContext = ruleContext;
            return this;
        }
    }
}

