/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.server.impl.FileLockNodeManager;

public class AIOFileLockNodeManager
extends FileLockNodeManager {
    public AIOFileLockNodeManager(String directory) {
        super(directory);
    }

    @Override
    protected FileLock tryLock(int lockPos) throws Exception {
        File file = this.newFileForRegionLock(lockPos);
        int handle = AsynchronousFileImpl.openFile(file.getAbsolutePath());
        if (handle < 0) {
            throw new IOException("couldn't open file " + file.getAbsolutePath());
        }
        FileLock lock = AsynchronousFileImpl.lock(handle);
        if (lock == null) {
            AsynchronousFileImpl.closeFile(handle);
        }
        return lock;
    }

    @Override
    protected FileLock lock(int liveLockPos) throws IOException {
        File file = this.newFileForRegionLock(liveLockPos);
        int handle = AsynchronousFileImpl.openFile(file.getAbsolutePath());
        if (handle < 0) {
            throw new IOException("couldn't open file " + file.getAbsolutePath());
        }
        while (!this.interrupted) {
            FileLock lockFile = AsynchronousFileImpl.lock(handle);
            if (lockFile != null) {
                return lockFile;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return null;
    }

    protected File newFileForRegionLock(int liveLockPos) {
        File file = this.newFile("server." + liveLockPos + ".lock");
        return file;
    }
}

